/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sync.model.impl;

import com.liferay.sync.model.SyncDLFileVersionDiff;
import com.liferay.sync.service.SyncDLFileVersionDiffLocalServiceUtil;

/**
 * The extended model base implementation for the SyncDLFileVersionDiff service. Represents a row in the &quot;SyncDLFileVersionDiff&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SyncDLFileVersionDiffImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SyncDLFileVersionDiffImpl
 * @see SyncDLFileVersionDiff
 * @generated
 */
public abstract class SyncDLFileVersionDiffBaseImpl
	extends SyncDLFileVersionDiffModelImpl implements SyncDLFileVersionDiff {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sync dl file version diff model instance should use the <code>SyncDLFileVersionDiff</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SyncDLFileVersionDiffLocalServiceUtil.addSyncDLFileVersionDiff(
				this);
		}
		else {
			SyncDLFileVersionDiffLocalServiceUtil.updateSyncDLFileVersionDiff(
				this);
		}
	}

}