/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.model.listener;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.sync.internal.model.listener.SyncBaseModelListener;
import com.liferay.sync.model.SyncDLObject;
import java.util.Date;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={ModelListener.class})
public class ResourcePermissionModelListener
extends SyncBaseModelListener<ResourcePermission> {
    public void onBeforeCreate(ResourcePermission resourcePermission) throws ModelListenerException {
        SyncDLObject syncDLObject = this.getSyncDLObject(resourcePermission);
        if (syncDLObject == null) {
            return;
        }
        if (resourcePermission.hasActionId("VIEW")) {
            this.updateSyncDLObject(syncDLObject);
        }
    }

    public void onBeforeRemove(ResourcePermission resourcePermission) throws ModelListenerException {
        SyncDLObject syncDLObject = this.getSyncDLObject(resourcePermission);
        if (syncDLObject == null) {
            return;
        }
        if (resourcePermission.hasActionId("VIEW")) {
            Date date = new Date();
            syncDLObject.setModifiedTime(date.getTime());
            syncDLObject.setLastPermissionChangeDate(date);
            this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
        }
    }

    public void onBeforeUpdate(ResourcePermission resourcePermission) throws ModelListenerException {
        SyncDLObject syncDLObject = this.getSyncDLObject(resourcePermission);
        if (syncDLObject == null) {
            return;
        }
        ResourcePermission originalResourcePermission = this.resourcePermissionLocalService.fetchResourcePermission(resourcePermission.getResourcePermissionId());
        if (originalResourcePermission.hasActionId("VIEW") && !resourcePermission.hasActionId("VIEW")) {
            Date date = new Date();
            syncDLObject.setModifiedTime(date.getTime());
            syncDLObject.setLastPermissionChangeDate(date);
            this.syncDLObjectLocalService.updateSyncDLObject(syncDLObject);
        } else if (!originalResourcePermission.hasActionId("VIEW") && resourcePermission.hasActionId("VIEW")) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                NoticeableExecutorService noticeableExecutorService = this.portalExecutorManager.getPortalExecutor(ResourcePermissionModelListener.class.getName());
                noticeableExecutorService.submit(() -> {
                    try {
                        this.updateSyncDLObject(syncDLObject);
                    }
                    catch (Exception e) {
                        throw new ModelListenerException((Throwable)e);
                    }
                    return null;
                });
                return null;
            });
        }
    }
}

