/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TagParser {
    private TagParser() {
    }

    static StreamTokenizer makeTokenizer(String tagValue) {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(tagValue));
        tokenizer.resetSyntax();
        tokenizer.wordChars(65, 90);
        tokenizer.wordChars(97, 122);
        tokenizer.wordChars(48, 57);
        tokenizer.wordChars(45, 45);
        tokenizer.wordChars(95, 95);
        tokenizer.wordChars(46, 46);
        tokenizer.wordChars(60, 60);
        tokenizer.wordChars(62, 62);
        tokenizer.quoteChar(39);
        tokenizer.quoteChar(34);
        tokenizer.whitespaceChars(32, 32);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.eolIsSignificant(false);
        return tokenizer;
    }

    public static Map<String, String> parseNamedParameters(String tagValue) {
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        StreamTokenizer tokenizer = TagParser.makeTokenizer(tagValue);
        try {
            while (tokenizer.nextToken() == -3) {
                String key = tokenizer.sval;
                if (tokenizer.nextToken() == 61) {
                    switch (tokenizer.nextToken()) {
                        case -3: 
                        case 34: 
                        case 39: {
                            paramMap.put(key, tokenizer.sval);
                        }
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return paramMap;
    }

    public static String[] parseWords(String tagValue) {
        StreamTokenizer tokenizer = TagParser.makeTokenizer(tagValue);
        ArrayList<String> wordList = new ArrayList<String>();
        try {
            while (tokenizer.nextToken() != -1) {
                if (tokenizer.sval == null) {
                    wordList.add(Character.toString((char)tokenizer.ttype));
                    continue;
                }
                wordList.add(tokenizer.sval);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error tokenizing tag");
        }
        return wordList.toArray(new String[0]);
    }

    public static List<String> parseParameters(String tagValue) {
        StreamTokenizer tokenizer = TagParser.makeTokenizer(tagValue);
        LinkedList<String> wordList = new LinkedList<String>();
        try {
            while (tokenizer.nextToken() != -1) {
                StringBuilder param = new StringBuilder();
                if (tokenizer.sval != null) {
                    param.append(tokenizer.sval);
                }
                while (tokenizer.nextToken() != -1) {
                    if (tokenizer.sval == null && ('=' == (char)tokenizer.ttype || ',' == (char)tokenizer.ttype)) {
                        param.append(Character.toString((char)tokenizer.ttype));
                        tokenizer.nextToken();
                        param.append(tokenizer.sval);
                        continue;
                    }
                    tokenizer.pushBack();
                    break;
                }
                wordList.add(param.toString());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error tokenizing tag");
        }
        return wordList;
    }
}

