/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.source.formatter.processor;

import com.liferay.source.formatter.check.util.SourceUtil;

import java.io.File;
import java.io.IOException;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class PropertiesSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws IOException {
		return getFileNames(
			new String[] {
				"**/docroot/dtd/**", "**/Language_*.properties",
				"**/lportal.properties"
			},
			getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		if (isPortalSource() || isSubrepository()) {
			return _INCLUDES;
		}

		return new String[] {
			"**/liferay-plugin-package.properties", "**/portal.properties",
			"**/portal-ext.properties", "**/portlet.properties",
			"**/poshi.properties", "**/service.properties",
			"**/source-formatter.properties", "**/test.properties"
		};
	}

	@Override
	protected File format(
			File file, String fileName, String absolutePath, String content)
		throws Exception {

		if (fileName.endsWith(".properties") && SourceUtil.isXML(content)) {
			return file;
		}

		return super.format(file, fileName, absolutePath, content);
	}

	private static final String[] _INCLUDES = {
		"**/*.properties", "**/.eslintignore", "**/.prettierignore"
	};

}