/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassContext
implements Serializable {
    private Map<String, JavaClass> classMap = new LinkedHashMap<String, JavaClass>();
    private Map<String, JavaPackage> packageMap = new LinkedHashMap<String, JavaPackage>();
    private Set<JavaSource> sourceSet = new LinkedHashSet<JavaSource>();

    public JavaClass getClassByName(String name) {
        return this.classMap.get(name);
    }

    public JavaClass removeClassByName(String name) {
        return this.classMap.remove(name);
    }

    public List<JavaClass> getClasses() {
        return Collections.unmodifiableList(new LinkedList<JavaClass>(this.classMap.values()));
    }

    public void add(JavaClass javaClass) {
        this.classMap.put(javaClass.getBinaryName(), javaClass);
    }

    public JavaPackage getPackageByName(String name) {
        return this.packageMap.get(name);
    }

    public JavaPackage removePackageByName(String name) {
        return this.packageMap.remove(name);
    }

    public void add(JavaPackage jPackage) {
        if (jPackage != null) {
            this.packageMap.put(jPackage.getName(), jPackage);
        }
    }

    public List<JavaPackage> getPackages() {
        return Collections.unmodifiableList(new LinkedList<JavaPackage>(this.packageMap.values()));
    }

    public void add(JavaSource source) {
        this.sourceSet.add(source);
    }

    public List<JavaSource> getSources() {
        return Collections.unmodifiableList(new LinkedList<JavaSource>(this.sourceSet));
    }
}

