/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TSConfigFileCheck
extends BaseFileCheck {
    private static final Pattern _namePattern = Pattern.compile("([ \t]name)\\s*:\\s*'(.*)'");

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        String path;
        if (!absolutePath.contains("/modules/test/playwright/tests/") || !fileName.endsWith("/config.ts")) {
            return content;
        }
        int x = absolutePath.lastIndexOf("/");
        String playwrightTestDirLocation = absolutePath.substring(0, x);
        File file = new File(playwrightTestDirLocation + "/test.properties");
        if (!file.exists()) {
            this.addMessage(fileName, "Missing test.properties, test.properties should be in the same folder as config.ts");
        }
        if (!(file = new File((path = playwrightTestDirLocation.substring(0, x = playwrightTestDirLocation.lastIndexOf("/"))) + "/main")).exists()) {
            this.addMessage(fileName, StringBundler.concat("Missing \"main\" folder in ", playwrightTestDirLocation, ", ts.config should be placed in \"main\" folder or ", "another folder at the same level of \"main\""));
            return content;
        }
        return this._checkConfig(fileName, content, playwrightTestDirLocation);
    }

    private String _checkConfig(String fileName, String content, String playwrightTestDirLocation) {
        int x = content.indexOf("export const config = ");
        if (x == -1) {
            this.addMessage(fileName, "Missing \"export const config\"");
            return content;
        }
        String config = this._getConfig(content, x);
        if (config == null) {
            return content;
        }
        Matcher matcher = _namePattern.matcher(config);
        if (!matcher.find()) {
            this.addMessage(fileName, "Missing \"name\" in \"export const config\"");
            return content;
        }
        String[] parts = playwrightTestDirLocation.split("/");
        int length = parts.length;
        String projectName = parts[length - 2] + "." + parts[length - 1];
        String newConfig = StringUtil.replaceFirst(config, matcher.group(), StringBundler.concat(matcher.group(1), ": '", projectName, "'"));
        if (!config.equals(newConfig)) {
            return StringUtil.replaceFirst(content, config, newConfig, x);
        }
        return content;
    }

    private String _getConfig(String content, int x) {
        String s;
        int y = x + 22;
        do {
            if ((y = content.indexOf("}", y + 1)) != -1) continue;
            return null;
        } while (ToolsUtil.isInsideQuotes(content, y) || this.getLevel(s = content.substring(x, y + 1), "{", "}") != 0);
        return s;
    }
}

