/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.nio;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class CharsetEncoderUtil {
    public static ByteBuffer encode(String charsetName, CharBuffer charBuffer) {
        try {
            return CharsetEncoderUtil.encode(charsetName, CodingErrorAction.REPLACE, charBuffer);
        }
        catch (CharacterCodingException cce) {
            throw new Error(cce);
        }
    }

    public static ByteBuffer encode(String charsetName, CodingErrorAction codingErrorAction, CharBuffer charBuffer) throws CharacterCodingException {
        CharsetEncoder charsetEncoder = CharsetEncoderUtil.getCharsetEncoder(charsetName, codingErrorAction);
        return charsetEncoder.encode(charBuffer);
    }

    public static CharsetEncoder getCharsetEncoder(String charsetName) {
        return CharsetEncoderUtil.getCharsetEncoder(charsetName, CodingErrorAction.REPLACE);
    }

    public static CharsetEncoder getCharsetEncoder(String charsetName, CodingErrorAction codingErrorAction) {
        Charset charset = Charset.forName(charsetName);
        CharsetEncoder charsetEncoder = charset.newEncoder();
        charsetEncoder.onMalformedInput(codingErrorAction);
        charsetEncoder.onUnmappableCharacter(codingErrorAction);
        return charsetEncoder;
    }
}

