/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.List;

public class JavaJSImportMapsContributorCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("JSImportMapsContributor.java")) {
            return content;
        }
        int x = -1;
        while ((x = content.indexOf(".put(", x + 1)) != -1) {
            List<String> parameterNames = JavaSourceUtil.getParameterNames(JavaSourceUtil.getMethodCall(content, x));
            if (parameterNames.size() != 2) continue;
            String importName = parameterNames.get(0);
            String resourcePath = parameterNames.get(1);
            if (SourceUtil.isLiteralString(importName) && !importName.endsWith("/api\"") && !resourcePath.contains("__liferay__/exports")) {
                this.addMessage(fileName, "Import map name should end with \"/api\"", this.getLineNumber(content, x));
            }
            if (resourcePath.contains("__liferay__/api.js") || resourcePath.contains("__liferay__/exports")) continue;
            this.addMessage(fileName, "Import map resource path should only contain \"__liferay__/api.js\" or \"__liferay__/exports\"", this.getLineNumber(content, x));
        }
        return content;
    }
}

