/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.WhitespaceCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.IOException;

public class PropertiesWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("\t")) {
                    line = StringUtil.replace(line, '\t', "    ");
                }
                if (line.contains(" \t")) {
                    line = StringUtil.replace(line, " \t", "     ");
                }
                if (line.matches("\\s*[^\\s#].*[,=]\\\\")) {
                    line = this._fixLeadingSpaces(line);
                }
                if (previousLine.matches("\\s*[^\\s#].*[,=]\\\\")) {
                    String leadingSpaces = SourceUtil.getLeadingSpaces(line);
                    String expectedLeadingSpaces = SourceUtil.getLeadingSpaces(previousLine);
                    if (previousLine.endsWith("=\\")) {
                        expectedLeadingSpaces = expectedLeadingSpaces + "    ";
                    }
                    if (!leadingSpaces.equals(expectedLeadingSpaces)) {
                        line = StringUtil.replaceFirst(line, leadingSpaces, expectedLeadingSpaces);
                    }
                    if (line.matches(" {4,}]")) {
                        line = line.substring(4);
                    }
                }
                sb.append(line);
                sb.append("\n");
                previousLine = line;
            }
        }
        return super.doProcess(fileName, absolutePath, sb.toString());
    }

    @Override
    protected boolean isAllowTrailingSpaces(String line) {
        String trimmedLine = StringUtil.removeChar(line, ' ');
        return trimmedLine.endsWith("=");
    }

    private String _fixLeadingSpaces(String line) {
        String leadingSpaces = SourceUtil.getLeadingSpaces(line);
        int leadingSpacesLength = leadingSpaces.length();
        int remainder = leadingSpacesLength % 4;
        if (remainder == 0) {
            return leadingSpaces + StringUtil.trimLeading(line);
        }
        if (leadingSpacesLength / 4 > 0) {
            leadingSpaces = leadingSpaces.substring(remainder);
        } else {
            StringBundler sb = new StringBundler(remainder);
            sb.append(leadingSpaces);
            for (int i = 0; i < remainder - 1; ++i) {
                sb.append(" ");
            }
            leadingSpaces = sb.toString();
        }
        return leadingSpaces + StringUtil.trimLeading(line);
    }
}

