/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.comparator.ElementComparator;
import com.liferay.source.formatter.check.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLTilesDefsFileCheck
extends BaseFileCheck {
    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/tiles-defs.xml")) {
            this._checkTilesDefsXML(fileName, content);
        }
        return content;
    }

    private void _checkTilesDefsXML(String fileName, String content) {
        Document document = SourceUtil.readXML(content);
        if (document == null) {
            return;
        }
        this.checkElementOrder(fileName, document.getRootElement(), "definition", null, new TilesDefinitionElementComparator());
    }

    private class TilesDefinitionElementComparator
    extends ElementComparator {
        private TilesDefinitionElementComparator() {
        }

        @Override
        public int compare(Element definitionElement1, Element definitionElement2) {
            String definitionName1 = this.getElementName(definitionElement1);
            if (definitionName1.equals("portlet")) {
                return -1;
            }
            return super.compare(definitionElement1, definitionElement2);
        }
    }
}

