/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.check;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.check.BaseCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class InnerExceptionClassCheck
extends BaseCheck {
    private static final String _MSG_INCORRECT_CLASS_DEFINITION = "class.definition.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        String absolutePath = this.getAbsolutePath();
        if (!absolutePath.endsWith("Exception.java")) {
            return;
        }
        DetailAST parentDetailAST = detailAST.getParent();
        if (parentDetailAST != null || !this._isExtendedException(detailAST)) {
            return;
        }
        if (this._hasPublicConstructor(detailAST) && this._hasPublicStaticInnerClass(detailAST)) {
            this.log(detailAST, _MSG_INCORRECT_CLASS_DEFINITION, new Object[0]);
        }
    }

    private boolean _hasPublicConstructor(DetailAST detailAST) {
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> constructorDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 8);
        for (DetailAST constructorDefinitionDetailAST : constructorDefinitionDetailASTList) {
            DetailAST modifiersDetailAST = constructorDefinitionDetailAST.findFirstToken(5);
            if (!modifiersDetailAST.branchContains(62)) continue;
            return true;
        }
        return false;
    }

    private boolean _hasPublicStaticInnerClass(DetailAST detailAST) {
        DetailAST objBlockDetailAST = detailAST.findFirstToken(6);
        List<DetailAST> classDefinitionDetailASTList = this.getAllChildTokens(objBlockDetailAST, false, 14);
        for (DetailAST classDefinitionDetailAST : classDefinitionDetailASTList) {
            DetailAST modifiersDetailAST = classDefinitionDetailAST.findFirstToken(5);
            if (!modifiersDetailAST.branchContains(62) || !modifiersDetailAST.branchContains(64)) continue;
            return true;
        }
        return false;
    }

    private boolean _isExtendedException(DetailAST detailAST) {
        DetailAST extendsClauseDetailAST = detailAST.findFirstToken(18);
        if (extendsClauseDetailAST == null) {
            return false;
        }
        String extendsClassName = null;
        DetailAST firstChildDetailAST = extendsClauseDetailAST.getFirstChild();
        if (firstChildDetailAST.getType() == 59) {
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)firstChildDetailAST);
            String[] parts = StringUtil.split(fullIdent.getText(), "\\.");
            extendsClassName = parts[parts.length - 1];
        } else if (firstChildDetailAST.getType() == 58) {
            extendsClassName = this.getName(extendsClauseDetailAST);
        }
        return extendsClassName.endsWith("Exception");
    }
}

