/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseTagAttributesCheck;
import java.util.ArrayList;
import java.util.List;

public class CSPIllegalTagsCheck
extends BaseTagAttributesCheck {
    private static final String _FTL_AND_VM_ILLEGAL_TAG_NAMES_KEY = "ftlAndVmIllegalTagNames";
    private static final String _JSP_ILLEGAL_TAG_NAMES_KEY = "jspIllegalTagNames";
    private static final String _REPLACED_TAG_NAMES_KEY = "replacedTagNames";

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        List<Object> illegalTagNames = new ArrayList();
        List<Object> replacedTagNames = new ArrayList();
        if (fileName.endsWith(".jsp") || fileName.endsWith(".jspf") || fileName.endsWith(".jspx")) {
            illegalTagNames = this.getAttributeValues(_JSP_ILLEGAL_TAG_NAMES_KEY, absolutePath);
            replacedTagNames = this.getAttributeValues(_REPLACED_TAG_NAMES_KEY, absolutePath);
        } else if (fileName.endsWith(".ftl") || fileName.endsWith(".vm")) {
            illegalTagNames = this.getAttributeValues(_FTL_AND_VM_ILLEGAL_TAG_NAMES_KEY, absolutePath);
        }
        String lowerCaseContent = StringUtil.toLowerCase(content);
        for (String string : illegalTagNames) {
            int x = -1;
            while ((x = lowerCaseContent.indexOf("<" + string, x + 1)) != -1) {
                String tagString;
                if (this.isJavaSource(content, x) || Validator.isNull(tagString = this.getTag(content, x)) || string.equals("link") && !tagString.contains("rel=\"stylesheet\"")) continue;
                int lineNumber = this.getLineNumber(content, x);
                if (replacedTagNames.contains(string)) {
                    this.addMessage(fileName, StringBundler.concat("Use <aui:", string, "> tag instead of <", string, ">, see LPD-18227"), lineNumber);
                    continue;
                }
                this.addMessage(fileName, StringBundler.concat("Do not use <", string, "> tag, see LPD-47204"), lineNumber);
            }
        }
        return content;
    }
}

