/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaStringStartsWithSubstringCheck
extends BaseJavaTermCheck {
    private static final Pattern _substringContainsPattern = Pattern.compile("(\\S*)\\.contains(\\(([^))]*)\\).*?=\\s*(\\1)\\.substring\\((\\3)\\.length\\(\\)\\))", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        Matcher matcher = _substringContainsPattern.matcher(javaTerm.getContent());
        return matcher.replaceAll("$1.startsWith$2");
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR, JAVA_METHOD};
    }
}

