/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.check.BaseJavaTermCheck;
import com.liferay.source.formatter.check.util.JavaSourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaCompanyScopedIdsCheck
extends BaseJavaTermCheck {
    private static final Pattern _createTablePattern = Pattern.compile("create table (\\w+) \\(");
    private static List<String> _entityIds;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        String content = javaTerm.getContent();
        if (absolutePath.contains("-test/")) {
            return content;
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        if (!(javaClass.hasAnnotation("Component") || javaClass.isStatic() || this.isUpgradeProcess(absolutePath, fileContent))) {
            return content;
        }
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            List<String> entityIds;
            JavaVariable javaVariable;
            String variableName;
            if (!childJavaTerm.isJavaVariable() || StringUtil.containsIgnoreCase(variableName = (javaVariable = (JavaVariable)childJavaTerm).getName(), "companyId", "") || !this._containsEntityId(entityIds = this._getEntityIds(), variableName)) continue;
            String variableTypeName = this.getVariableTypeName(javaVariable.getContent(), childJavaTerm, fileContent, fileName, variableName, true, false);
            if (variableTypeName.equals("Set<Long>")) {
                this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "add", variableName);
                continue;
            }
            if (!variableTypeName.startsWith("Map<Long")) continue;
            this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "compute", variableName);
            this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "computeIfAbsent", variableName);
            this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "computeIfPresent", variableName);
            this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "put", variableName);
            this._checkCompanyScopedIds(fileName, content, entityIds, javaTerm, "putIfAbsent", variableName);
        }
        return content;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkCompanyScopedIds(String fileName, String content, List<String> entityIds, JavaTerm javaTerm, String methodName, String variableName) {
        int x = -1;
        while ((x = content.indexOf(StringBundler.concat(variableName, ".", methodName, "("), x + 1)) != -1) {
            List<String> getParameterNames = JavaSourceUtil.getParameterNames(JavaSourceUtil.getMethodCall(content, x));
            String parameter = getParameterNames.get(0);
            if (parameter.contains("CompanyId") || parameter.contains("companyId") || !this._containsEntityId(entityIds, parameter)) continue;
            this.addMessage(fileName, StringBundler.concat(variableName, ".", methodName, ", ", variableName, " are not unique across companies so it is needed to make ", "the collection company scoped"), javaTerm.getLineNumber(x));
        }
    }

    private boolean _containsEntityId(List<String> entityIds, String name) {
        for (String entityId : entityIds) {
            if (!StringUtil.containsIgnoreCase(name, entityId, "")) continue;
            return true;
        }
        return false;
    }

    private synchronized List<String> _getEntityIds() throws Exception {
        if (_entityIds != null) {
            return _entityIds;
        }
        _entityIds = new ArrayList<String>();
        File portalDir = this.getPortalDir();
        List<String> fileNames = SourceFormatterUtil.scanForFileNames(portalDir.getCanonicalPath(), new String[]{"**/*-service/src/main/resources/META-INF/sql/tables.sql"});
        fileNames.add(portalDir + "/sql/portal-tables.sql");
        for (String fileName : fileNames) {
            String content = FileUtil.read(new File(fileName));
            Matcher matcher = _createTablePattern.matcher(content);
            while (matcher.find()) {
                List<String> primaryKeys;
                String tableContent;
                int x = matcher.end();
                while ((x = content.indexOf(");", x + 1)) == -1 || this.getLevel(tableContent = content.substring(matcher.start(), x + 2)) != 0) {
                }
                if (!tableContent.contains("\tcompanyId LONG") || (primaryKeys = this.getPrimaryKeys(tableContent)).isEmpty()) continue;
                _entityIds.add(primaryKeys.get(0));
            }
        }
        return _entityIds;
    }
}

