/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util.comparator;

import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.util.OrderByComparator;

public class GroupIdComparator
extends OrderByComparator<Group> {
    public static final String ORDER_BY_ASC = "Group_.groupId ASC";
    public static final String ORDER_BY_DESC = "Group_.groupId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"groupId"};
    private static final GroupIdComparator _INSTANCE_ASCENDING = new GroupIdComparator(true);
    private static final GroupIdComparator _INSTANCE_DESCENDING = new GroupIdComparator(false);
    private final boolean _ascending;

    public static GroupIdComparator getInstance(boolean ascending) {
        if (ascending) {
            return _INSTANCE_ASCENDING;
        }
        return _INSTANCE_DESCENDING;
    }

    @Override
    public int compare(Group group1, Group group2) {
        long groupId1 = group1.getGroupId();
        long groupId2 = group2.getGroupId();
        int value = 0;
        if (groupId1 < groupId2) {
            value = -1;
        } else if (groupId1 > groupId2) {
            value = 1;
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }

    private GroupIdComparator(boolean ascending) {
        this._ascending = ascending;
    }
}

