/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.source.formatter.check.BaseFileCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

public class PropertiesLanguageKeysCheck
extends BaseFileCheck {
    private static final String _ALLOWED_LANGUAGE_KEYS_KEY = "allowedLanguageKeys";
    private static final String _PORTAL_LANGUAGE_PROPERTIES_FILE_NAME = "portalLanguagePropertiesFileName";
    private Properties _portalLanguageProperties;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/content/Language.properties") || absolutePath.contains("/source/formatter/dependencies/")) {
            return content;
        }
        StringBundler sb = new StringBundler();
        Properties portalLanguageProperties = this._getPortalLanguageProperties(absolutePath);
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String portalLanguageValue;
                String[] array = line.split("=", 2);
                if (array.length < 2) {
                    sb.append(line);
                    sb.append("\n");
                    continue;
                }
                String key = array[0];
                String value = array[1];
                if (portalLanguageProperties != null && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/") && value.equals(portalLanguageValue = portalLanguageProperties.getProperty(key))) continue;
                if (!this._isAllowedLanguageKey(key, absolutePath) && value.matches("(?s).*<([a-zA-Z0-9]+)[^>]*>.*?<\\/\\1>.*")) {
                    this.addMessage(fileName, "Remove HTML markup for \"" + key + "\"", this.getLineNumber(content, content.indexOf(line)));
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private synchronized Properties _getPortalLanguageProperties(String absolutePath) throws IOException {
        String portalLanguagePropertiesFileName = this.getAttributeValue(_PORTAL_LANGUAGE_PROPERTIES_FILE_NAME, absolutePath);
        if (absolutePath.endsWith(portalLanguagePropertiesFileName)) {
            return null;
        }
        if (this._portalLanguageProperties != null) {
            return this._portalLanguageProperties;
        }
        Properties portalLanguageProperties = new Properties();
        InputStream inputStream = this.getPortalInputStream(portalLanguagePropertiesFileName, absolutePath);
        if (inputStream != null) {
            portalLanguageProperties.load(inputStream);
        }
        this._portalLanguageProperties = portalLanguageProperties;
        return this._portalLanguageProperties;
    }

    private boolean _isAllowedLanguageKey(String key, String absolutePath) {
        String s = key.replaceAll("[^\\w.-]", "");
        List<String> allowedLanguageKeys = this.getAttributeValues(_ALLOWED_LANGUAGE_KEYS_KEY, absolutePath);
        for (String allowedLanguageKey : allowedLanguageKeys) {
            if (!s.equals(allowedLanguageKey)) continue;
            return true;
        }
        return false;
    }
}

