/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.NamedThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class BatchProcessor<T> {
    private volatile int _batchSize;
    private final Consumer<List<T>> _consumer;
    private final Queue<T> _queue = new ConcurrentLinkedQueue<T>();
    private final AtomicInteger _queueSize = new AtomicInteger();
    private final ScheduledExecutorService _scheduledExecutorService;
    private volatile ScheduledFuture<?> _scheduledFuture;

    public BatchProcessor(long batchInterval, int batchSize, Consumer<List<T>> consumer, String name) {
        this._consumer = consumer;
        this._scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory(name, 5, null));
        this.configure(batchInterval, batchSize);
    }

    public void add(T item) {
        this._queue.add(item);
        int size = this._queueSize.incrementAndGet();
        if (size >= this._batchSize) {
            this._flush();
        }
    }

    public void close() {
        this._scheduledExecutorService.shutdown();
        this._flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(long batchInterval, int batchSize) {
        BatchProcessor batchProcessor = this;
        synchronized (batchProcessor) {
            if (this._scheduledFuture != null) {
                this._scheduledFuture.cancel(false);
            }
            this._scheduledFuture = batchInterval > 0L ? this._scheduledExecutorService.scheduleWithFixedDelay(this::_flush, batchInterval, batchInterval, TimeUnit.MILLISECONDS) : null;
            this._batchSize = batchSize;
        }
    }

    private void _flush() {
        ArrayList items = new ArrayList();
        Object item = null;
        while (true) {
            T t = this._queue.poll();
            item = t;
            if (t == null) break;
            items.add(item);
        }
        int flushSize = items.size();
        if (flushSize > 0) {
            int size = this._queueSize.get();
            while (!this._queueSize.compareAndSet(size, size - flushSize)) {
                size = this._queueSize.get();
            }
            this._consumer.accept(items);
        }
    }
}

