/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LocaleUtil {
    public static final Locale BRAZIL = new Locale("pt", "BR");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale HUNGARY = new Locale("hu", "HU");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NETHERLANDS = new Locale("nl", "NL");
    public static final Locale PORTUGAL = new Locale("pt", "PT");
    public static final Locale PRC = Locale.PRC;
    public static final Locale ROOT = Locale.ROOT;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale SPAIN = new Locale("es", "ES");
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    private static final String _BETA_SUFFIX = " [Beta]";
    private static final Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static Locale _locale = new Locale("en", "US");
    private static final Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static boolean equals(Locale locale1, Locale locale2) {
        String languageId1 = LocaleUtil.toLanguageId(locale1);
        String languageId2 = LocaleUtil.toLanguageId(locale2);
        return StringUtil.equalsIgnoreCase(languageId1, languageId2);
    }

    public static Locale fromLanguageId(String languageId) {
        return LocaleUtil.fromLanguageId(languageId, true);
    }

    public static Locale fromLanguageId(String languageId, boolean validate) {
        return LocaleUtil.fromLanguageId(languageId, validate, true);
    }

    public static Locale fromLanguageId(String languageId, boolean validate, boolean useDefault) {
        if (languageId == null) {
            if (useDefault) {
                return LocaleUtil.getDefault();
            }
            return null;
        }
        Locale locale = LocaleUtil._fromLanguageId(languageId);
        if (validate) {
            boolean languageCode = false;
            if (languageId.indexOf(95) < 0 && languageId.indexOf(45) < 0) {
                languageCode = true;
            }
            if (languageCode && !LanguageUtil.isAvailableLanguageCode(languageId) || !languageCode && !LanguageUtil.isAvailableLocale(locale)) {
                if (_log.isWarnEnabled()) {
                    _log.warn(languageId + " is not a valid language id");
                }
                if (useDefault) {
                    return LocaleUtil.getDefault();
                }
                return null;
            }
        }
        return locale;
    }

    public static Locale[] fromLanguageIds(List<String> languageIds) {
        Locale[] locales = new Locale[languageIds.size()];
        for (int i = 0; i < languageIds.size(); ++i) {
            locales[i] = LocaleUtil.fromLanguageId(languageIds.get(i), true);
        }
        return locales;
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        for (int i = 0; i < languageIds.length; ++i) {
            locales[i] = LocaleUtil.fromLanguageId(languageIds[i], true);
        }
        return locales;
    }

    public static Locale getDefault() {
        Locale locale = LocaleThreadLocal.getDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return _locale;
    }

    public static Map<String, String> getISOLanguages(Locale locale) {
        TreeMap<String, String> isoLanguages = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String isoLanguageId : Locale.getISOLanguages()) {
            Locale isoLocale = LocaleUtil.fromLanguageId(isoLanguageId, true);
            isoLanguages.put(isoLocale.getDisplayLanguage(locale), isoLanguageId);
        }
        return isoLanguages;
    }

    public static String getLocaleDisplayName(Locale displayLocale, Locale locale) {
        String key = "language." + displayLocale.getLanguage();
        String displayName = LanguageUtil.get(locale, key);
        if (displayName.equals(key)) {
            return displayLocale.getDisplayName(locale);
        }
        String country = LocaleUtil._getDisplayCountry(displayLocale, locale);
        if (Validator.isNull(country)) {
            return displayName;
        }
        return StringBundler.concat(displayName, " ", "(", country, ")");
    }

    public static String getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return LocaleUtil._getDisplayName(locale.getDisplayLanguage(locale), LocaleUtil._getDisplayCountry(locale, locale), locale, duplicateLanguages);
    }

    public static Locale getMostRelevantLocale() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = LocaleUtil.getDefault();
        }
        return locale;
    }

    public static String getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        String language = locale.getDisplayLanguage(locale);
        if (language.length() > 3) {
            language = locale.getLanguage();
            language = StringUtil.toUpperCase(language);
        }
        return LocaleUtil._getDisplayName(language, StringUtil.toUpperCase(locale.getCountry()), locale, duplicateLanguages);
    }

    public static Locale getSiteDefault() {
        Locale locale = LocaleThreadLocal.getSiteDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return LocaleUtil.getDefault();
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            _locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            _locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            _locale = new Locale(userLanguage, userCountry, userVariant);
        }
        LocaleThreadLocal.setDefaultLocale(_locale);
    }

    public static String toBCP47LangTag(Locale locale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        if (languageId.equals("zh_CN")) {
            return "zh-Hans";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-Hant";
        }
        return LocaleUtil.toBCP47LanguageId(languageId);
    }

    public static String toBCP47LanguageId(Locale locale) {
        return LocaleUtil.toBCP47LanguageId(LocaleUtil.toLanguageId(locale));
    }

    public static String toBCP47LanguageId(String languageId) {
        if (languageId.equals("zh_CN")) {
            return "zh-Hans-CN";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-Hant-TW";
        }
        return StringUtil.replace(languageId, '_', '-');
    }

    public static String[] toBCP47LanguageIds(Locale[] locales) {
        return LocaleUtil.toBCP47LanguageIds(LocaleUtil.toLanguageIds(locales));
    }

    public static String[] toBCP47LanguageIds(String[] languageIds) {
        String[] bcp47LanguageIds = new String[languageIds.length];
        for (int i = 0; i < languageIds.length; ++i) {
            bcp47LanguageIds[i] = LocaleUtil.toBCP47LanguageId(languageIds[i]);
        }
        return bcp47LanguageIds;
    }

    public static String[] toDisplayNames(Collection<Locale> locales, Locale locale) {
        String[] displayNames = new String[locales.size()];
        int i = 0;
        for (Locale curLocale : locales) {
            displayNames[i++] = curLocale.getDisplayName(locale);
        }
        return displayNames;
    }

    public static String toLanguageId(Locale locale) {
        if (locale == null) {
            locale = _locale;
        }
        String country = locale.getCountry();
        boolean hasCountry = false;
        if (country.length() != 0) {
            hasCountry = true;
        }
        String variant = locale.getVariant();
        boolean hasVariant = false;
        if (variant.length() != 0) {
            hasVariant = true;
        }
        if (!hasCountry && !hasVariant) {
            return locale.getLanguage();
        }
        int length = 3;
        if (hasCountry && hasVariant) {
            length = 5;
        }
        StringBundler sb = new StringBundler(length);
        sb.append(locale.getLanguage());
        if (hasCountry) {
            sb.append("_");
            sb.append(country);
        }
        if (hasVariant) {
            sb.append("_");
            sb.append(variant);
        }
        return sb.toString();
    }

    public static String[] toLanguageIds(Collection<Locale> locales) {
        String[] languageIds = new String[locales.size()];
        int i = 0;
        for (Locale locale : locales) {
            languageIds[i++] = LocaleUtil.toLanguageId(locale);
        }
        return languageIds;
    }

    public static String[] toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            languageIds[i] = LocaleUtil.toLanguageId(locales[i]);
        }
        return languageIds;
    }

    public static Map<String, Object> toMap(Locale locale) {
        return HashMapBuilder.put("country", locale.getCountry()).put("displayCountry", locale.getDisplayCountry()).put("displayLanguage", locale.getDisplayLanguage()).put("displayName", locale.getDisplayName()).put("displayScript", locale.getDisplayScript()).put("displayVariant", locale.getDisplayVariant()).put("extensionKeys", (String)((Object)locale.getExtensionKeys())).put("ISO3Country", (Set<Character>)((Object)locale.getISO3Country())).put("ISO3Language", (Set<Character>)((Object)locale.getISO3Language())).put("language", (Set<Character>)((Object)locale.getLanguage())).put("script", (Set<Character>)((Object)locale.getScript())).put("unicodeLocaleAttributes", locale.getUnicodeLocaleAttributes()).put("unicodeLocaleKeys", locale.getUnicodeLocaleKeys()).put("variant", (Set<String>)((Object)locale.getVariant())).build();
    }

    public static String toW3cLanguageId(Locale locale) {
        return LocaleUtil.toW3cLanguageId(LocaleUtil.toLanguageId(locale));
    }

    public static String toW3cLanguageId(String languageId) {
        return StringUtil.replace(languageId, '_', '-');
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return LocaleUtil.toW3cLanguageIds(LocaleUtil.toLanguageIds(locales));
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        String[] w3cLanguageIds = new String[languageIds.length];
        for (int i = 0; i < languageIds.length; ++i) {
            w3cLanguageIds[i] = LocaleUtil.toW3cLanguageId(languageIds[i]);
        }
        return w3cLanguageIds;
    }

    private static Locale _fromLanguageId(String languageId) {
        Locale locale = _locales.get(languageId);
        if (locale != null) {
            return locale;
        }
        int pos = (languageId = languageId.equals("zh-Hans-CN") ? "zh_CN" : (languageId.equals("zh-Hant-TW") ? "zh_TW" : StringUtil.replace(languageId, '-', '_'))).indexOf(95);
        if (pos == -1) {
            locale = new Locale(languageId);
        } else {
            String[] languageIdParts = StringUtil.split(languageId, '_');
            String languageCode = languageIdParts[0];
            String countryCode = languageIdParts[1];
            String variant = null;
            if (languageIdParts.length > 2) {
                variant = languageIdParts[2];
            }
            locale = Validator.isNotNull(variant) ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
        }
        _locales.put(languageId, locale);
        return locale;
    }

    private static String _getDisplayCountry(Locale displayLocale, Locale locale) {
        String country = displayLocale.getDisplayCountry(locale);
        String variant = displayLocale.getDisplayVariant(locale);
        if (Validator.isNull(variant)) {
            return country;
        }
        return StringUtil.merge(new String[]{country, variant}, ", ");
    }

    private static String _getDisplayName(String language, String country, Locale locale, Set<String> duplicateLanguages) {
        String displayName = null;
        displayName = duplicateLanguages.contains(locale.getLanguage()) && Validator.isNotNull(country) ? StringUtil.appendParentheticalSuffix(language, country) : language;
        if (LanguageUtil.isBetaLocale(locale)) {
            displayName = displayName.concat(_BETA_SUFFIX);
        }
        return displayName;
    }
}

