/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.Jdk14LogFactoryImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactory;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LogFactoryUtil {
    private static volatile LogFactory _logFactory = new Jdk14LogFactoryImpl();
    private static final ConcurrentMap<String, LogWrapper> _logWrappers = new ConcurrentHashMap<String, LogWrapper>();

    public static Log getLog(Class<?> c) {
        return LogFactoryUtil.getLog(c.getName());
    }

    public static Log getLog(String name) {
        LogWrapper logWrapper = (LogWrapper)_logWrappers.get(name);
        if (logWrapper == null) {
            Log log = _logFactory.getLog(name);
            logWrapper = SanitizerLogWrapper.isEnabled() ? new SanitizerLogWrapper(log) : (log instanceof LogWrapper ? (LogWrapper)log : new LogWrapper(_logFactory.getLog(name)));
            LogWrapper previousLogWrapper = _logWrappers.putIfAbsent(name, logWrapper);
            if (previousLogWrapper != null) {
                logWrapper = previousLogWrapper;
            }
        }
        return logWrapper;
    }

    public static LogFactory getLogFactory() {
        return _logFactory;
    }

    public static void setLogFactory(LogFactory logFactory) {
        for (Map.Entry entry : _logWrappers.entrySet()) {
            String name = (String)entry.getKey();
            LogWrapper logWrapper = (LogWrapper)entry.getValue();
            logWrapper.setLog(logFactory.getLog(name));
        }
        _logFactory = logFactory;
    }
}

