/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependencyArtifactsCheck
extends BaseFileCheck {
    private static final String _ALLOWED_ARTIFACTS_FILE_NAMES_KEY = "allowedArtifactsFileNames";
    private static final String _ALLOWED_VERSION_ARTIFACTS_KEY = "allowedVersionArtifacts";
    private static final String _ENFORCE_VERSION_ARTIFACTS_KEY = "enforceVersionArtifacts";
    private static final String _RENAME_ARTIFACTS_KEY = "renameArtifacts";
    private static final Pattern _artifactPattern = Pattern.compile("\n\t*(.* (group: \"[^\"]+\", name: \"([^\"]+)\", version: \"([^\"]+)\"))");
    private static final Pattern _bndConditionalPackagePattern = Pattern.compile("-conditionalpackage:(.*[^\\\\])(\n|\\Z)", 32);
    private Map<String, String> _projectNamesMap;

    @Override
    public boolean isLiferaySourceCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        content = this._renameDependencyNames(fileName, absolutePath, content);
        List<String> enforceVersionArtifacts = this.getAttributeValues(_ENFORCE_VERSION_ARTIFACTS_KEY, absolutePath);
        content = this._enforceDependencyVersions(content, enforceVersionArtifacts, absolutePath);
        Matcher matcher = _artifactPattern.matcher(content);
        while (matcher.find()) {
            String name = matcher.group(3);
            String version = matcher.group(4);
            content = this._formatVersion(fileName, absolutePath, content, matcher.group(2), name, version, matcher.start(3), enforceVersionArtifacts);
            if (!this.isSubrepository() && !absolutePath.contains("/modules/apps/") && !absolutePath.contains("/modules/dxp/apps/") && !absolutePath.contains("/modules/private/apps/") || this._isTestUtilModule(absolutePath)) continue;
            content = this._fixMicroVersion(fileName, content, matcher.group(1), name, version);
        }
        if (absolutePath.endsWith("/lib/development/dependencies.properties") || absolutePath.endsWith("/lib/portal/dependencies.properties")) {
            this._checkDependenciesPropertiesFile(fileName, content, enforceVersionArtifacts);
        }
        return content;
    }

    private void _checkDependenciesPropertiesFile(String fileName, String content, List<String> enforceVersionArtifacts) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            int lineNumber = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String dependencyGroupAndName;
                String[] artifactParts;
                ++lineNumber;
                String[] parts = StringUtil.split(line, "=");
                if (parts.length != 2 || enforceVersionArtifacts.contains(parts[1]) || (artifactParts = StringUtil.split(parts[1], ":")).length != 3 || !ListUtil.exists(enforceVersionArtifacts, arg_0 -> GradleDependencyArtifactsCheck.lambda$_checkDependenciesPropertiesFile$0(dependencyGroupAndName = artifactParts[0] + ":" + artifactParts[1], arg_0))) continue;
                this.addMessage(fileName, StringBundler.concat("The version of \"", dependencyGroupAndName, "\" does not match the version in \"", _ENFORCE_VERSION_ARTIFACTS_KEY, "\" property in source-formatter.properties"), lineNumber);
            }
        }
    }

    private String _enforceDependencyVersions(String content, List<String> enforceVersionArtifacts, String absolutePath) {
        List<String> allowedVersionArtifacts = this.getAttributeValues(_ALLOWED_VERSION_ARTIFACTS_KEY, absolutePath);
        for (String artifact : enforceVersionArtifacts) {
            String[] artifactParts = StringUtil.split(artifact, ":");
            if (allowedVersionArtifacts.contains(artifactParts[0] + ":" + artifactParts[1])) continue;
            Pattern pattern = Pattern.compile(StringBundler.concat("(group: \"", artifactParts[0], "\", name: \"", artifactParts[1], "\",.* version: \").*?(\")"));
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll("$1" + artifactParts[2] + "$2");
        }
        return content;
    }

    private String _fixMicroVersion(String fileName, String content, String line, String name, String version) throws IOException {
        String conditionalPackageContent;
        String bndFileContent;
        Matcher matcher;
        if (!line.startsWith("compileOnly ") && !line.startsWith("provided ")) {
            return content;
        }
        if (!name.startsWith("com.liferay.") || !version.matches("[0-9]+\\.[0-9]+\\.[1-9][0-9]*")) {
            return content;
        }
        int pos = fileName.lastIndexOf(47);
        String bndFileLocation = fileName.substring(0, pos + 1) + "bnd.bnd";
        File bndFile = new File(bndFileLocation);
        if (bndFile.exists() && (matcher = _bndConditionalPackagePattern.matcher(bndFileContent = FileUtil.read(bndFile))).find() && (conditionalPackageContent = matcher.group()).contains(name)) {
            return content;
        }
        pos = version.lastIndexOf(".");
        String newLine = StringUtil.replaceFirst(line, "version: \"" + version + "\"", "version: \"" + version.substring(0, pos + 1) + "0\"");
        return StringUtil.replaceFirst(content, line, newLine);
    }

    private String _formatVersion(String fileName, String absolutePath, String content, String dependency, String name, String version, int pos, List<String> enforceVersionArtifacts) throws IOException {
        if (this.isSubrepository() || !fileName.endsWith("build.gradle") || absolutePath.contains("/modules/util/") || absolutePath.contains("/workspaces/")) {
            return content;
        }
        if (!(name.equals("com.liferay.portal.impl") || name.equals("com.liferay.portal.kernel") || name.equals("com.liferay.portal.test") || name.equals("com.liferay.portal.test.integration") || name.equals("com.liferay.util.bridges") || name.equals("com.liferay.util.java") || name.equals("com.liferay.util.taglib"))) {
            if (version.equals("default")) {
                this.addMessage(fileName, "Do not use \"default\" version for \"" + name + "\"", this.getLineNumber(content, pos));
            } else if (name.startsWith("com.liferay") && !name.startsWith("com.liferay.portletmvc4spring") && !name.startsWith("com.liferay.gradle") && !this._isMasterOnlyFile(absolutePath)) {
                for (String enforceVersionArtifact : enforceVersionArtifacts) {
                    if (!enforceVersionArtifact.startsWith("com.liferay:" + name + ":") && !enforceVersionArtifact.startsWith("com.liferay.arquillian:" + name + ":")) continue;
                    return content;
                }
                Map<String, String> projectNamesMap = this._getProjectNamesMap(absolutePath);
                if (projectNamesMap.containsKey(name)) {
                    return StringUtil.replace(content, dependency, "project(\"" + projectNamesMap.get(name) + "\")");
                }
                this.addMessage(fileName, "Incorrect dependency \"" + name + "\"", this.getLineNumber(content, pos));
            }
        } else if (!version.equals("default") && !this._isMasterOnlyFile(absolutePath)) {
            return StringUtil.replaceFirst(content, version, "default", pos);
        }
        return content;
    }

    private String _getArtifactString(String artifact) {
        String[] array = StringUtil.split(artifact, ':');
        if (array.length != 2) {
            return null;
        }
        return StringBundler.concat("group: \"", array[0], "\", name: \"", array[1], "\"");
    }

    private synchronized Map<String, String> _getProjectNamesMap(String absolutePath) throws IOException {
        if (this._projectNamesMap != null) {
            return this._projectNamesMap;
        }
        this._projectNamesMap = new HashMap<String, String>();
        String content = this.getModulesPropertiesContent(absolutePath);
        if (Validator.isNull(content)) {
            return this._projectNamesMap;
        }
        List<String> lines = ListUtil.fromString(content);
        for (String line : lines) {
            String key;
            String[] array = StringUtil.split(line, "=");
            if (array.length != 2 || !(key = array[0]).startsWith("project.name[")) continue;
            this._projectNamesMap.put(key.substring(13, key.length() - 1), array[1]);
        }
        return this._projectNamesMap;
    }

    private boolean _isAllowedArtifactFile(String fileName, String oldArtifact, List<String> allowedArtifactsFileNames) {
        for (String allowedArtifactsFileName : allowedArtifactsFileNames) {
            String[] allowedArtifactArray = StringUtil.split(allowedArtifactsFileName, "->");
            if (allowedArtifactArray.length != 2 || !StringUtil.equals(oldArtifact, allowedArtifactArray[0]) || !fileName.endsWith(allowedArtifactArray[1])) continue;
            return true;
        }
        return false;
    }

    private boolean _isMasterOnlyFile(String absolutePath) {
        File file;
        int x = absolutePath.length();
        do {
            if ((x = absolutePath.lastIndexOf("/", x - 1)) != -1) continue;
            return false;
        } while (!(file = new File(absolutePath.substring(0, x + 1) + ".lfrbuild-master-only")).exists());
        return true;
    }

    private boolean _isTestUtilModule(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        String moduleName = absolutePath.substring(y + 1, x);
        return moduleName.endsWith("-test-util");
    }

    private String _renameDependencyNames(String fileName, String absolutePath, String content) {
        List<String> allowedArtifactsFileNames = this.getAttributeValues(_ALLOWED_ARTIFACTS_FILE_NAMES_KEY, absolutePath);
        List<String> renameArtifacts = this.getAttributeValues(_RENAME_ARTIFACTS_KEY, absolutePath);
        for (String renameArtifact : renameArtifacts) {
            String[] renameArtifactArray = StringUtil.split(renameArtifact, "->");
            if (renameArtifactArray.length != 2) continue;
            String newArtifactString = this._getArtifactString(renameArtifactArray[1]);
            String oldArtifactString = this._getArtifactString(renameArtifactArray[0]);
            if (newArtifactString == null || oldArtifactString == null || this._isAllowedArtifactFile(fileName, renameArtifactArray[0], allowedArtifactsFileNames)) continue;
            content = StringUtil.replace(content, oldArtifactString, newArtifactString);
        }
        return content;
    }

    private static /* synthetic */ boolean lambda$_checkDependenciesPropertiesFile$0(String dependencyGroupAndName, String enforceVersionArtifact) {
        return enforceVersionArtifact.startsWith(dependencyGroupAndName + ":");
    }
}

