/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.poshi.core.script;

import com.liferay.poshi.core.script.PoshiScriptParserException;
import java.net.URL;

public class UnbalancedCodeException
extends PoshiScriptParserException {
    public UnbalancedCodeException(String msg, int index, String code, URL filePathURL) {
        super(msg, UnbalancedCodeException._getErrorLineNumber(index, code), UnbalancedCodeException._getErrorSnippet(index, code), filePathURL);
    }

    private static int _getErrorLineNumber(int index, String code) {
        int lineNumber = 1;
        for (int i = 0; i < index; ++i) {
            if (code.charAt(i) != '\n') continue;
            ++lineNumber;
        }
        return lineNumber;
    }

    private static String _getErrorSnippet(int index, String code) {
        int lineNumber = 1;
        int newLineIndex = -1;
        for (int i = 0; i < index; ++i) {
            if (code.charAt(i) != '\n') continue;
            ++lineNumber;
            newLineIndex = i;
        }
        int column = 1;
        for (int i = newLineIndex + 1; i < index; ++i) {
            if (code.charAt(i) == '\t') {
                column += 4;
                continue;
            }
            ++column;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(UnbalancedCodeException._getLine(lineNumber, code));
        sb.append("\n");
        for (int i = 1; i < column; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }

    private static String _getLine(int lineNumber, String code) {
        String[] lines = code.split("\n");
        return lines[lineNumber - 1].replace("\t", "    ");
    }
}

