/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoshiSmokeTestCheck
extends BaseFileCheck {
    private static final Pattern _testMethodPattern = Pattern.compile("\n\t+test \\w+ \\{");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith(".testcase") || SourceUtil.isXML(content)) {
            return content;
        }
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        if (!shortFileName.contains("Smoke") && !shortFileName.contains("smoke")) {
            return content;
        }
        Matcher matcher = _testMethodPattern.matcher(content);
        if (matcher.find()) {
            String s = content.substring(0, matcher.start());
            if (!s.contains("property ci.retries.disabled = \"true\";")) {
                this.addMessage(fileName, "Missing property ci.retries.disabled = \"true\" in definition for smoke test");
                return content;
            }
            StringBundler sb = new StringBundler(s);
            s = content.substring(matcher.start());
            for (String line : s.split("\n")) {
                if (Validator.isNull(line)) {
                    sb.append("\n");
                    continue;
                }
                String trimmedLine = line.trim();
                if (trimmedLine.equals("property ci.retries.disabled = \"true\";")) continue;
                sb.append(line);
                sb.append("\n");
            }
            if (sb.index() > 1) {
                sb.setIndex(sb.index() - 1);
            }
            return sb.toString();
        }
        return content;
    }
}

