/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.check;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.check.BaseFileCheck;
import com.liferay.source.formatter.check.util.SourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class PropertiesArchivedModulesCheck
extends BaseFileCheck {
    private List<String> _archivedModuleDirectoryNames;

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws IOException {
        if (!fileName.endsWith("/test.properties")) {
            return content;
        }
        List<String> archivedModuleDirectoryNames = this._getArchivedModuleDirectoryNames();
        if (archivedModuleDirectoryNames.isEmpty()) {
            return content;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String value;
            String key = (String)enumeration.nextElement();
            if (!key.contains("test.batch.class.names.includes") || Validator.isNull(value = properties.getProperty(key))) continue;
            List<String> propertyValues = ListUtil.fromString(value, ",");
            for (String propertyValue : propertyValues) {
                String moduleName = "";
                if (propertyValue.startsWith("**/")) {
                    int x = propertyValue.indexOf(47, 3);
                    if (x == -1) continue;
                    moduleName = propertyValue.substring(3, x);
                } else if (propertyValue.startsWith("apps/archived/")) {
                    moduleName = propertyValue.replaceFirst("apps/archived/(.+?)/.*", "$1");
                }
                if (!archivedModuleDirectoryNames.contains(moduleName)) continue;
                this.addMessage(fileName, StringBundler.concat("Remove dependency \"", moduleName, "\" in property \"", key, "\", since it points to an archived module"));
            }
        }
        return content;
    }

    private synchronized List<String> _getArchivedModuleDirectoryNames() throws IOException {
        if (this._archivedModuleDirectoryNames != null) {
            return this._archivedModuleDirectoryNames;
        }
        this._archivedModuleDirectoryNames = new ArrayList<String>();
        File modulesDir = new File(this.getPortalDir(), "modules/apps/archived");
        if (!modulesDir.exists()) {
            return Collections.emptyList();
        }
        Files.walkFileTree(modulesDir.toPath(), EnumSet.noneOf(FileVisitOption.class), 15, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes basicFileAttributes) {
                String moduleDirectoryName = PropertiesArchivedModulesCheck.this._getModuleDirectoryName(dirPath);
                if (moduleDirectoryName == null) {
                    return FileVisitResult.CONTINUE;
                }
                PropertiesArchivedModulesCheck.this._archivedModuleDirectoryNames.add(moduleDirectoryName);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
        return this._archivedModuleDirectoryNames;
    }

    private String _getModuleDirectoryName(Path dirPath) {
        String absolutePath = SourceUtil.getAbsolutePath(dirPath);
        int x = absolutePath.indexOf("/modules/apps/archived/");
        if (x == -1) {
            return null;
        }
        String directoryPath = absolutePath.substring(x + 23);
        if (!directoryPath.contains("/")) {
            return directoryPath;
        }
        return null;
    }
}

