/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import ClayAlert from '@clayui/alert';
import ClayForm, {ClayInput} from '@clayui/form';
import ClayLabel from '@clayui/label';
import ClayLayout from '@clayui/layout';
import React from 'react';

import {useSelector, useStateDispatch} from '../contexts/StateContext';
import selectSelectedItem from '../selectors/selectSelectedItem';
import selectStructureError from '../selectors/selectStructureError';
import selectStructureLabel from '../selectors/selectStructureLabel';
import StructureFieldSettings from './StructureFieldSettings';

export function StructureSettings() {
	const dispatch = useStateDispatch();
	const error = useSelector(selectStructureError);
	const label = useSelector(selectStructureLabel);

	return (
		<ClayLayout.ContainerFluid view>
			{error ? (
				<ClayAlert
					displayType="danger"
					role={null}
					title={Liferay.Language.get('error')}
				>
					{error}
				</ClayAlert>
			) : null}

			<ClayLabel className="mb-3" displayType="info">
				{Liferay.Language.get('content')}
			</ClayLabel>

			<ClayForm.Group>
				<ClayInput
					aria-label={Liferay.Language.get('structure-label')}
					className="form-control-inline structure-builder__title-input"
					onChange={(event) =>
						dispatch({label: event.target.value, type: 'set-label'})
					}
					sizing="lg"
					type="text"
					value={label}
				/>
			</ClayForm.Group>
		</ClayLayout.ContainerFluid>
	);
}

export default function () {
	const selectedItem = useSelector(selectSelectedItem);

	if (selectedItem.type === 'structure') {
		return <StructureSettings />;
	}

	return <StructureFieldSettings fieldName={selectedItem.name} />;
}
