/**
 * SPDX-FileCopyrightText: (c) 2026 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

import Label from '@clayui/label';
import React from 'react';

declare type NameDisplayType =
	| 'secondary'
	| 'info'
	| 'warning'
	| 'danger'
	| 'success'
	| 'unstyled';

const mapKeyToNameDisplayType: {[key: string]: NameDisplayType} = {
	blocked: 'danger',
	done: 'success',
	inProgress: 'info',
	notStarted: 'secondary',
	overdue: 'warning',
};

interface StateLabelProps {
	key: string;
	name: string;
}

const StateLabel = ({key, name}: StateLabelProps) => (
	<Label displayType={mapKeyToNameDisplayType[key]}>{name}</Label>
);

export default StateLabel;
