/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharing.notifications.internal.notifications;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.notifications.BaseModelUserNotificationHandler;
import com.liferay.portal.kernel.notifications.UserNotificationHandler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharing.model.SharingEntry;
import com.liferay.sharing.service.SharingEntryLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_sharing_web_portlet_SharingPortlet"}, service={UserNotificationHandler.class})
public class SharingUserNotificationHandler
extends BaseModelUserNotificationHandler {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private SharingEntryLocalService _sharingEntryLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public SharingUserNotificationHandler() {
        this.setPortletId("com_liferay_sharing_web_portlet_SharingPortlet");
    }

    protected String getBody(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return this._getMessage(this._jsonFactory.createJSONObject(userNotificationEvent.getPayload()), userNotificationEvent);
    }

    protected String getLink(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(userNotificationEvent.getPayload());
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(jsonObject.getLong("classPK"));
        if (sharingEntry == null) {
            return super.getLink(userNotificationEvent, serviceContext);
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (themeDisplay == null) {
            return super.getLink(userNotificationEvent, serviceContext);
        }
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)sharingEntry.getClassName());
        if (assetRendererFactory == null) {
            return super.getLink(userNotificationEvent, serviceContext);
        }
        AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(sharingEntry.getClassPK());
        return assetRenderer.getURLViewInContext(themeDisplay, "");
    }

    protected String getTitle(UserNotificationEvent userNotificationEvent, ServiceContext serviceContext) throws Exception {
        return this._getMessage(this._jsonFactory.createJSONObject(userNotificationEvent.getPayload()), userNotificationEvent);
    }

    private String _getMessage(JSONObject jsonObject, UserNotificationEvent userNotificationEvent) throws Exception {
        SharingEntry sharingEntry = this._sharingEntryLocalService.fetchSharingEntry(jsonObject.getLong("classPK"));
        if (sharingEntry == null) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        AssetRenderer assetRenderer = this.getAssetRenderer(sharingEntry.getClassName(), sharingEntry.getClassPK());
        if (assetRenderer == null || this._isInTrash(sharingEntry.getClassName(), sharingEntry.getClassPK())) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent.getUserNotificationEventId());
            return null;
        }
        String message = jsonObject.getString("message");
        if (Validator.isNull((String)message)) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent);
        }
        return HtmlUtil.escape((String)message);
    }

    private boolean _isInTrash(String className, long classPK) throws Exception {
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler == null) {
            return false;
        }
        return trashHandler.isInTrash(classPK);
    }
}

