/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.schema.batch;

import com.liferay.portal.kernel.xml.simple.Element;
import com.liferay.sharepoint.connector.schema.BaseNode;
import com.liferay.sharepoint.connector.schema.batch.BatchField;

public class BatchMethod
extends BaseNode {
    private final BatchField[] _batchFields;
    private final int _batchMethodId;
    private final Command _command;

    public BatchMethod(int batchMethodId, Command command, BatchField ... batchFields) {
        this._batchMethodId = batchMethodId;
        this._command = command;
        this._batchFields = batchFields;
    }

    @Override
    protected String getNodeName() {
        return "Method";
    }

    @Override
    protected void populate(Element element) {
        element.addAttribute("Cmd", this._command.getProtocolValue());
        element.addAttribute("ID", String.valueOf(this._batchMethodId));
        for (BatchField batchField : this._batchFields) {
            batchField.attach(element);
        }
    }

    public static enum Command {
        DELETE("Delete"),
        NEW("New"),
        UPDATE("Update");

        private final String _protocolValue;

        public String getProtocolValue() {
            return this._protocolValue;
        }

        private Command(String protocolValue) {
            this._protocolValue = protocolValue;
        }
    }
}

