/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.schema;

import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharepoint.connector.SharepointRuntimeException;
import com.liferay.sharepoint.connector.schema.Node;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.encoding.AnyContentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    public Element getElement(AnyContentType anyContentType) {
        try {
            return anyContentType.get_any()[0].getAsDOM();
        }
        catch (Exception e) {
            throw new SharepointRuntimeException("Unable to parse response from the Sharepoint server", e);
        }
    }

    public Element getElement(String nodeName, org.w3c.dom.Node w3CNode) {
        for (org.w3c.dom.Node childW3CNode = w3CNode.getFirstChild(); childW3CNode != null; childW3CNode = childW3CNode.getNextSibling()) {
            String localName = childW3CNode.getLocalName();
            if (localName == null || !StringUtil.equalsIgnoreCase((String)localName, (String)nodeName)) continue;
            return (Element)childW3CNode;
        }
        return null;
    }

    public Element toElement(Node node) {
        return this._toElement(node.toXmlString());
    }

    public String toString(Element element) {
        TransformerFactory transformerFactory = SecureXMLFactoryProviderUtil.newTransformerFactory();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException tce) {
            throw new RuntimeException(tce);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter stringWriter = new StringWriter();
        try {
            transformer.transform(new DOMSource(element), new StreamResult(stringWriter));
        }
        catch (TransformerException te) {
            throw new RuntimeException(te);
        }
        StringBuffer stringBuffer = stringWriter.getBuffer();
        return stringBuffer.toString();
    }

    private Element _toElement(String xml) {
        try {
            DocumentBuilderFactory documentBuilderFactory = SecureXMLFactoryProviderUtil.newDocumentBuilderFactory();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            StringReader stringReader = new StringReader(xml);
            InputSource inputSource = new InputSource(stringReader);
            Document document = documentBuilder.parse(inputSource);
            return document.getDocumentElement();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        catch (SAXException saxe) {
            throw new RuntimeException(saxe);
        }
    }
}

