/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

public class PathHelper {
    public String buildPath(String folderPath, String name) {
        this.validatePath(folderPath);
        this.validateName(name);
        if (folderPath.equals("/")) {
            return "/" + name;
        }
        return folderPath + "/" + name;
    }

    public String getExtension(String path) {
        int pos = path.lastIndexOf(".");
        if (pos == -1) {
            return "";
        }
        return path.substring(pos + 1);
    }

    public String getName(String path) {
        this.validatePath(path);
        if (path.equals("/")) {
            return "/";
        }
        int pos = path.lastIndexOf("/");
        return path.substring(pos + 1);
    }

    public String getNameWithoutExtension(String path) {
        String name = this.getName(path);
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            return name;
        }
        return name.substring(0, pos);
    }

    public String getParentFolderPath(String path) {
        this.validatePath(path);
        int pos = path.lastIndexOf("/");
        if (pos == 0) {
            return "/";
        }
        return path.substring(0, pos);
    }

    public void validateName(String name) {
        if (name == null || name.contains("/")) {
            throw new IllegalArgumentException("Invalid file or folder name " + name);
        }
    }

    public void validatePath(String path) {
        if (path == null || !path.equals("/") && (!path.startsWith("/") || path.endsWith("/"))) {
            throw new IllegalArgumentException("Invalid path " + path);
        }
    }
}

