/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.connector.SharepointConnection;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.BatchOperation;
import com.liferay.sharepoint.connector.operation.CheckInFileOperation;
import com.liferay.sharepoint.connector.operation.CheckOutFileOperation;
import com.liferay.sharepoint.connector.operation.CopySharepointObjectOperation;
import com.liferay.sharepoint.connector.operation.DeleteSharepointObjectOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.connector.schema.batch.Batch;
import com.liferay.sharepoint.connector.schema.batch.BatchField;
import com.liferay.sharepoint.connector.schema.batch.BatchMethod;
import java.net.URL;

public class MoveSharepointObjectOperation
extends BaseOperation {
    private BatchOperation _batchOperation;
    private CheckInFileOperation _checkInFileOperation;
    private CheckOutFileOperation _checkOutFileOperation;
    private CopySharepointObjectOperation _copySharepointObjectOperation;
    private DeleteSharepointObjectOperation _deleteSharepointObjectOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;

    @Override
    public void afterPropertiesSet() {
        this._batchOperation = this.getOperation(BatchOperation.class);
        this._checkInFileOperation = this.getOperation(CheckInFileOperation.class);
        this._checkOutFileOperation = this.getOperation(CheckOutFileOperation.class);
        this._copySharepointObjectOperation = this.getOperation(CopySharepointObjectOperation.class);
        this._deleteSharepointObjectOperation = this.getOperation(DeleteSharepointObjectOperation.class);
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
    }

    public void execute(String path, String newPath) throws SharepointException {
        SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
        if (this.isRename(path, newPath)) {
            String newExtension;
            String oldExtension = pathHelper.getExtension(path);
            if (!oldExtension.equals(newExtension = pathHelper.getExtension(newPath))) {
                throw new SharepointException("Sharepoint does not support changing file extensions");
            }
            URL url = sharepointObject.getURL();
            String newName = pathHelper.getNameWithoutExtension(newPath);
            this._batchOperation.execute(new Batch(Batch.OnError.RETURN, null, new BatchMethod(0, BatchMethod.Command.UPDATE, new BatchField("ID", sharepointObject.getSharepointObjectId()), new BatchField("FileRef", url.toString()), new BatchField("BaseName", newName))));
        } else {
            this._copySharepointObjectOperation.execute(path, newPath);
            this._deleteSharepointObjectOperation.execute(path);
            this._checkInFileOperation.execute(newPath, "", SharepointConnection.CheckInType.MAJOR);
            if (Validator.isNotNull((String)sharepointObject.getCheckedOutBy())) {
                this._checkOutFileOperation.execute(newPath);
            }
        }
    }

    protected boolean isRename(String path, String newPath) {
        String parentFolderPath = pathHelper.getParentFolderPath(path);
        String newParentFolderPath = pathHelper.getParentFolderPath(newPath);
        return parentFolderPath.equals(newParentFolderPath);
    }
}

