/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.internal.util.RemoteExceptionUtil;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.SharepointConstants;
import com.liferay.sharepoint.connector.schema.query.Query;
import com.liferay.sharepoint.connector.schema.query.QueryField;
import com.liferay.sharepoint.connector.schema.query.QueryFieldsList;
import com.liferay.sharepoint.connector.schema.query.QueryOptionsList;
import com.liferay.sharepoint.connector.schema.query.option.ExpandUserFieldQueryOption;
import com.microsoft.schemas.sharepoint.soap.GetListItemsQuery;
import com.microsoft.schemas.sharepoint.soap.GetListItemsQueryOptions;
import com.microsoft.schemas.sharepoint.soap.GetListItemsResponseGetListItemsResult;
import com.microsoft.schemas.sharepoint.soap.GetListItemsViewFields;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.axis.encoding.AnyContentType;
import org.apache.axis.message.MessageElement;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetSharepointObjectsByQueryOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(GetSharepointObjectsByQueryOperation.class);
    private int _pathPrefixToRemoveLength;

    @Override
    public void afterPropertiesSet() {
        String libraryPath = this.sharepointConnectionInfo.getLibraryPath();
        String sitePath = this.sharepointConnectionInfo.getSitePath();
        this._pathPrefixToRemoveLength = libraryPath.length() + sitePath.length();
    }

    public List<SharepointObject> execute(Query query, QueryOptionsList queryOptionsList, String ... queryFieldNames) throws SharepointException {
        GetListItemsResponseGetListItemsResult getListItemsResponseGetListItemsResult = null;
        GetListItemsQuery getListItemsQuery = this.getGetListItemsQuery(query);
        GetListItemsViewFields getListItemsViewFields = this.getGetListItemsViewFields(queryFieldNames);
        if (!queryOptionsList.contains(ExpandUserFieldQueryOption.class)) {
            queryOptionsList = queryOptionsList.append(new ExpandUserFieldQueryOption(true));
        }
        GetListItemsQueryOptions getListItemsQueryOptions = this.getGetListItemsQueryOptions(queryOptionsList);
        try {
            getListItemsResponseGetListItemsResult = this.listsSoap.getListItems(this.sharepointConnectionInfo.getLibraryName(), "", getListItemsQuery, getListItemsViewFields, "", getListItemsQueryOptions, "");
        }
        catch (RemoteException re) {
            RemoteExceptionUtil.handleRemoteException(re);
        }
        this.log(query, queryOptionsList, getListItemsResponseGetListItemsResult);
        return this.getSharepointObjects(getListItemsResponseGetListItemsResult);
    }

    protected GetListItemsQuery getGetListItemsQuery(Query query) {
        GetListItemsQuery getListItemsQuery = new GetListItemsQuery();
        Element queryElement = xmlHelper.toElement(query);
        MessageElement queryMessageElement = new MessageElement(queryElement);
        getListItemsQuery.set_any(new MessageElement[]{queryMessageElement});
        return getListItemsQuery;
    }

    protected GetListItemsQueryOptions getGetListItemsQueryOptions(QueryOptionsList queryOptionsList) {
        Element queryOptionsListElement = xmlHelper.toElement(queryOptionsList);
        MessageElement queryOptionsListMessageElement = new MessageElement(queryOptionsListElement);
        GetListItemsQueryOptions getListItemsQueryOptions = new GetListItemsQueryOptions();
        getListItemsQueryOptions.set_any(new MessageElement[]{queryOptionsListMessageElement});
        return getListItemsQueryOptions;
    }

    protected GetListItemsViewFields getGetListItemsViewFields(String ... queryFieldNames) {
        QueryFieldsList queryFieldsList = new QueryFieldsList(this.toQueryFields(queryFieldNames));
        Element queryFieldsListElement = xmlHelper.toElement(queryFieldsList);
        MessageElement queryFieldsListMessageElement = new MessageElement(queryFieldsListElement);
        GetListItemsViewFields getListItemsViewFields = new GetListItemsViewFields();
        getListItemsViewFields.set_any(new MessageElement[]{queryFieldsListMessageElement});
        return getListItemsViewFields;
    }

    protected String getNodeValue(Node node, int index) {
        String nodeValue = node.getNodeValue();
        String[] parts = nodeValue.split(SharepointConstants.PATTERN_MULTI_VALUE_SEPARATOR);
        if (index < parts.length) {
            return parts[index];
        }
        return null;
    }

    protected Set<SharepointObject.Permission> getPermissions(String permissionsHexMask) {
        EnumSet<SharepointObject.Permission> permissions = EnumSet.noneOf(SharepointObject.Permission.class);
        long permisssionsMask = Long.valueOf(permissionsHexMask.substring(2), 16);
        for (SharepointObject.Permission permission : SharepointObject.Permission.values()) {
            long permissionBit = permisssionsMask & permission.getMask();
            if (permissionBit == 0L) continue;
            permissions.add(permission);
        }
        return permissions;
    }

    protected List<SharepointObject> getSharepointObjects(GetListItemsResponseGetListItemsResult getListItemsResponseGetListItemsResult) {
        ArrayList<SharepointObject> sharepointObjects = new ArrayList<SharepointObject>();
        Element getListItemsResponseGetListItemsResultElement = xmlHelper.getElement((AnyContentType)getListItemsResponseGetListItemsResult);
        Element dataElement = xmlHelper.getElement("Data", getListItemsResponseGetListItemsResultElement);
        NodeList nodeList = dataElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String localName = node.getLocalName();
            if (localName == null || !StringUtil.equalsIgnoreCase((String)localName, (String)"row")) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node owsFileRefNode = namedNodeMap.getNamedItem("ows_FileRef");
            String path = this.getNodeValue(owsFileRefNode, 1);
            path = path.substring(this._pathPrefixToRemoveLength);
            Node owsAuthorNode = namedNodeMap.getNamedItem("ows_Author");
            Node owsCheckedOutUserIdNode = namedNodeMap.getNamedItem("ows_CheckoutUser");
            if (owsCheckedOutUserIdNode == null) {
                owsCheckedOutUserIdNode = namedNodeMap.getNamedItem("ows_CheckedOutTitle");
            }
            Node owsCreatedX0020DateNode = namedNodeMap.getNamedItem("ows_Created_x0020_Date");
            Node owsFSObjTypeNode = namedNodeMap.getNamedItem("ows_FSObjType");
            Node owsLastX0020ModifiedNode = namedNodeMap.getNamedItem("ows_Last_x0020_Modified");
            Node owsPermMaskNode = namedNodeMap.getNamedItem("ows_PermMask");
            Node owsFileX0020SizeNode = namedNodeMap.getNamedItem("ows_File_x0020_Size");
            SharepointObject sharepointObject = new SharepointObject(this.getNodeValue(owsAuthorNode, 1), this.getNodeValue(owsCheckedOutUserIdNode, 1), this.parseDate(this.getNodeValue(owsCreatedX0020DateNode, 1)), Objects.equals(this.getNodeValue(owsFSObjTypeNode, 1), "1"), this.parseDate(this.getNodeValue(owsLastX0020ModifiedNode, 1)), path, this.getPermissions(owsPermMaskNode.getNodeValue()), GetterUtil.getLong((String)this.getNodeValue(owsFileRefNode, 0)), GetterUtil.getLong((String)this.getNodeValue(owsFileX0020SizeNode, 1)), this.toURL(path));
            sharepointObjects.add(sharepointObject);
        }
        return sharepointObjects;
    }

    protected void log(Query query, QueryOptionsList queryOptionsList, GetListItemsResponseGetListItemsResult getListItemsResponseGetListItemsResult) {
        if (!_log.isDebugEnabled()) {
            return;
        }
        Element element = xmlHelper.getElement((AnyContentType)getListItemsResponseGetListItemsResult);
        _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Query: ", query, "\nQuery options: ", queryOptionsList, "\nResult: ", xmlHelper.toString(element)}));
    }

    protected Date parseDate(String dateString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.setTimeZone(SharepointConstants.SHAREPOINT_OBJECT_TIME_ZONE);
            return dateFormat.parse(dateString);
        }
        catch (ParseException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to parse " + dateString + " to a Sharepoint object date"), (Throwable)pe);
            }
            return new Date(0L);
        }
    }

    protected QueryField[] toQueryFields(String[] queryFieldNames) {
        QueryField[] queryFields = new QueryField[queryFieldNames.length];
        for (int i = 0; i < queryFieldNames.length; ++i) {
            String queryFieldName = queryFieldNames[i];
            queryFields[i++] = new QueryField(queryFieldName);
        }
        return queryFields;
    }
}

