/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.SharepointResultException;
import com.liferay.sharepoint.connector.internal.util.RemoteExceptionUtil;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.connector.operation.QueryServiceSoapResult;
import com.microsoft.webservices.SharePoint.QueryService.QueryServiceSoap;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GetObjectsByQueryPacketOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(GetObjectsByQueryPacketOperation.class);
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private QueryServiceSoap _queryServiceSoap;
    private String _searchPrefix;
    private int _searchPrefixLength;

    @Override
    public void afterPropertiesSet() {
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
        this._searchPrefix = this.sharepointConnectionInfo.getServiceURL() + this.sharepointConnectionInfo.getLibraryPath();
        this._searchPrefixLength = this._searchPrefix.length();
    }

    public List<SharepointObject> execute(String queryPacket) throws SharepointException {
        try {
            String queryServiceSoapResultString = this._queryServiceSoap.query(queryPacket);
            QueryServiceSoapResult queryServiceSoapResult = new QueryServiceSoapResult(queryServiceSoapResultString);
            if (!queryServiceSoapResult.isSuccess()) {
                throw new SharepointResultException(queryServiceSoapResult.getStatus(), queryServiceSoapResult.getDebugErrorMessage());
            }
            if (queryServiceSoapResult.isEmpty()) {
                return Collections.emptyList();
            }
            List<String> queryServiceSoapResultLinkURLs = queryServiceSoapResult.getLinkURLs();
            ArrayList<SharepointObject> sharepointObjects = new ArrayList<SharepointObject>();
            for (String queryServiceSoapResultLinkURL : queryServiceSoapResultLinkURLs) {
                if (!queryServiceSoapResultLinkURL.startsWith(this._searchPrefix)) continue;
                String path = queryServiceSoapResultLinkURL.substring(this._searchPrefixLength);
                SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
                if (sharepointObject == null) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Ignored Sharepoint object at path " + path));
                    continue;
                }
                sharepointObjects.add(sharepointObject);
            }
            return sharepointObjects;
        }
        catch (RemoteException re) {
            RemoteExceptionUtil.handleRemoteException(re);
            throw new IllegalStateException();
        }
    }

    public void setQueryServiceSoap(QueryServiceSoap queryServiceSoap) {
        this._queryServiceSoap = queryServiceSoap;
    }
}

