/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.SharepointVersion;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class GetInputStreamOperation
extends BaseOperation {
    public InputStream execute(SharepointObject sharepointObject) throws SharepointException {
        URL url = sharepointObject.getURL();
        return this.execute(url);
    }

    public InputStream execute(SharepointVersion sharepointVersion) throws SharepointException {
        URL url = sharepointVersion.getURL();
        return this.execute(url);
    }

    protected void authenticate(HttpClient httpClient, URL url) {
        HttpClientParams httpClientParams = httpClient.getParams();
        httpClientParams.setAuthenticationPreemptive(true);
        AuthScope authScope = new AuthScope(url.getHost(), url.getPort(), url.getHost(), "BASIC");
        UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(this.sharepointConnectionInfo.getUsername(), this.sharepointConnectionInfo.getPassword());
        HttpState httpClientState = httpClient.getState();
        httpClientState.setCredentials(authScope, (Credentials)usernamePasswordCredentials);
    }

    protected InputStream execute(URL url) throws SharepointException {
        url = urlHelper.escapeURL(url);
        HttpClient httpClient = new HttpClient();
        this.authenticate(httpClient, url);
        GetMethod getMethod = new GetMethod(url.toString());
        getMethod.setDoAuthentication(true);
        try {
            int status = httpClient.executeMethod((HttpMethod)getMethod);
            if (status == 200) {
                InputStream inputStream = getMethod.getResponseBodyAsStream();
                byte[] bytes = null;
                try {
                    bytes = FileUtil.getBytes((InputStream)inputStream);
                }
                catch (IOException ioe) {
                    throw new SharepointException("Unable to read input stream", ioe);
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                return byteArrayInputStream;
            }
            try {
                throw new SharepointException(StringBundler.concat((Object[])new Object[]{"Downloading ", url, " failed with status ", status}));
            }
            catch (IOException ioe) {
                throw new SharepointException("Unable to communicate with the Sharepoint server", ioe);
            }
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

