/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.sharepoint.connector.SharepointConnection;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointObject;
import com.liferay.sharepoint.connector.SharepointResultException;
import com.liferay.sharepoint.connector.internal.util.RemoteExceptionUtil;
import com.liferay.sharepoint.connector.operation.AddFolderOperation;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectByPathOperation;
import com.liferay.sharepoint.connector.operation.GetSharepointObjectsByFolderOperation;
import com.microsoft.schemas.sharepoint.soap.CopyErrorCode;
import com.microsoft.schemas.sharepoint.soap.CopyResult;
import com.microsoft.schemas.sharepoint.soap.holders.CopyResultCollectionHolder;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.axis.holders.UnsignedIntHolder;

public class CopySharepointObjectOperation
extends BaseOperation {
    private static final Log _log = LogFactoryUtil.getLog(CopySharepointObjectOperation.class);
    private AddFolderOperation _addFolderOperation;
    private GetSharepointObjectByPathOperation _getSharepointObjectByPathOperation;
    private GetSharepointObjectsByFolderOperation _getSharepointObjectsByFolderOperation;

    @Override
    public void afterPropertiesSet() {
        this._addFolderOperation = this.getOperation(AddFolderOperation.class);
        this._getSharepointObjectByPathOperation = this.getOperation(GetSharepointObjectByPathOperation.class);
        this._getSharepointObjectsByFolderOperation = this.getOperation(GetSharepointObjectsByFolderOperation.class);
    }

    public void execute(String path, String newPath) throws SharepointException {
        SharepointObject sharepointObject = this._getSharepointObjectByPathOperation.execute(path);
        if (sharepointObject == null) {
            throw new SharepointException("Unable to find Sharepoint object at " + path);
        }
        if (sharepointObject.isFile()) {
            this.copyFile(path, newPath);
        } else {
            this.copyFolder(path, newPath);
        }
    }

    protected void copyFile(String path, String newPath) throws SharepointException {
        URL pathURL = this.toURL(path);
        URL newPathURL = this.toURL(newPath);
        CopyResultCollectionHolder copyResultCollectionHolder = new CopyResultCollectionHolder();
        try {
            this.copySoap.copyIntoItemsLocal(pathURL.toString(), new String[]{newPathURL.toString()}, new UnsignedIntHolder(), copyResultCollectionHolder);
        }
        catch (RemoteException re) {
            RemoteExceptionUtil.handleRemoteException(re);
        }
        CopyResult copyResult = copyResultCollectionHolder.value[0];
        CopyErrorCode copyErrorCode = copyResult.getErrorCode();
        if (copyErrorCode != CopyErrorCode.Success) {
            throw new SharepointResultException(copyErrorCode.toString(), copyResult.getErrorMessage());
        }
    }

    protected void copyFolder(String path, String newPath) throws SharepointException {
        this.createFolder(newPath);
        List<SharepointObject> sharepointObjects = this._getSharepointObjectsByFolderOperation.execute(path, SharepointConnection.ObjectTypeFilter.ALL);
        for (SharepointObject sharepointObject : sharepointObjects) {
            String sharepointObjectPath = pathHelper.buildPath(path, sharepointObject.getName());
            String newSharepointObjectPath = pathHelper.buildPath(newPath, sharepointObject.getName());
            if (sharepointObject.isFile()) {
                this.copyFile(sharepointObjectPath, newSharepointObjectPath);
                continue;
            }
            this.copyFolder(sharepointObjectPath, newSharepointObjectPath);
        }
    }

    protected void createFolder(String folderPath) {
        block2: {
            try {
                String parentFolderPath = pathHelper.getParentFolderPath(folderPath);
                String folderName = pathHelper.getName(folderPath);
                this._addFolderOperation.execute(parentFolderPath, folderName);
            }
            catch (SharepointException se) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to create folder at " + folderPath), (Throwable)se);
            }
        }
    }
}

