/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector.operation;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.sharepoint.connector.SharepointConnection;
import com.liferay.sharepoint.connector.SharepointException;
import com.liferay.sharepoint.connector.SharepointResultException;
import com.liferay.sharepoint.connector.internal.util.RemoteExceptionUtil;
import com.liferay.sharepoint.connector.operation.BaseOperation;
import com.liferay.sharepoint.connector.operation.CheckInFileOperation;
import com.microsoft.schemas.sharepoint.soap.CopyErrorCode;
import com.microsoft.schemas.sharepoint.soap.CopyResult;
import com.microsoft.schemas.sharepoint.soap.FieldInformation;
import com.microsoft.schemas.sharepoint.soap.holders.CopyResultCollectionHolder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis.holders.UnsignedIntHolder;

public class AddOrUpdateFileOperation
extends BaseOperation {
    private static final FieldInformation[] _EMPTY_FIELD_INFORMATIONS = new FieldInformation[0];
    private CheckInFileOperation _checkInFileOperation;

    @Override
    public void afterPropertiesSet() {
        this._checkInFileOperation = this.getOperation(CheckInFileOperation.class);
    }

    public void execute(String filePath, String changeLog, InputStream inputStream) throws SharepointException {
        URL filePathURL = this.toURL(filePath);
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)inputStream);
        }
        catch (IOException ioe) {
            throw new SharepointException("Unable to read input stream", ioe);
        }
        CopyResultCollectionHolder copyResultCollectionHolder = new CopyResultCollectionHolder();
        try {
            this.copySoap.copyIntoItems(" ", new String[]{filePathURL.toString()}, _EMPTY_FIELD_INFORMATIONS, bytes, new UnsignedIntHolder(), copyResultCollectionHolder);
        }
        catch (RemoteException re) {
            RemoteExceptionUtil.handleRemoteException(re);
        }
        CopyResult copyResult = copyResultCollectionHolder.value[0];
        CopyErrorCode copyErrorCode = copyResult.getErrorCode();
        if (copyErrorCode != CopyErrorCode.Success) {
            throw new SharepointResultException(copyErrorCode.toString(), copyResult.getErrorMessage());
        }
        if (changeLog != null) {
            this._checkInFileOperation.execute(filePath, changeLog, SharepointConnection.CheckInType.MAJOR);
        }
    }
}

