/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sharepoint.connector;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.sharepoint.connector.SharepointConnection;
import com.liferay.sharepoint.connector.SharepointRuntimeException;
import com.liferay.sharepoint.connector.operation.URLHelper;
import java.net.URL;

public class SharepointConnectionInfo {
    private static final URLHelper _urlHelper = new URLHelper();
    private final String _libraryName;
    private final String _libraryPath;
    private final String _password;
    private final String _serverAddress;
    private final int _serverPort;
    private final String _serverProtocol;
    private final SharepointConnection.ServerVersion _serverVersion;
    private final URL _serviceURL;
    private final String _sitePath;
    private final String _username;

    public SharepointConnectionInfo(SharepointConnection.ServerVersion serverVersion, String serverProtocol, String serverAddress, int serverPort, String sitePath, String libraryName, String libraryPath, String username, String password) throws SharepointRuntimeException {
        this.validate(sitePath, username, password);
        this._serverVersion = serverVersion;
        this._serverProtocol = serverProtocol;
        this._serverAddress = serverAddress;
        this._serverPort = serverPort;
        this._sitePath = sitePath;
        this._libraryName = libraryName;
        this._libraryPath = libraryPath;
        this._username = username;
        this._password = password;
        this._serviceURL = _urlHelper.toURL(StringBundler.concat((Object[])new Object[]{this._serverProtocol, "://", this._serverAddress, ":", this._serverPort, this._sitePath, "/"}));
    }

    public String getLibraryName() {
        return this._libraryName;
    }

    public String getLibraryPath() {
        return this._libraryPath;
    }

    public String getPassword() {
        return this._password;
    }

    public String getServerAddress() {
        return this._serverAddress;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public SharepointConnection.ServerVersion getServerVersion() {
        return this._serverVersion;
    }

    public URL getServiceURL() {
        return this._serviceURL;
    }

    public String getSitePath() {
        return this._sitePath;
    }

    public String getUsername() {
        return this._username;
    }

    protected void validate(String sitePath, String username, String password) {
        if (sitePath.equals("")) {
            return;
        }
        if (sitePath.equals("/")) {
            throw new IllegalArgumentException("Use an empty string instead of a forward slash for the root site path");
        }
        if (!sitePath.startsWith("/")) {
            throw new IllegalArgumentException("Site path must start with a forward slash");
        }
        if (!sitePath.equals("/") && sitePath.endsWith("/")) {
            throw new IllegalArgumentException("Site path must not end with a forward slash");
        }
        if (Validator.isNull((String)username)) {
            throw new SharepointRuntimeException("Username is null");
        }
        if (Validator.isNull((String)password)) {
            throw new SharepointRuntimeException("Password is null");
        }
    }
}

