/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.server.manager.internal.executor;

import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ExecutorPathResolver {
    public static final String ROOT_EXECUTOR_PATH = "/";
    private final Set<String> _availableExecutorPaths;

    public ExecutorPathResolver(Set<String> availableExecutorPaths) {
        this._availableExecutorPaths = availableExecutorPaths;
    }

    public String getExecutorPath(String path) {
        String executorPath = path;
        if (Validator.isNull((String)executorPath)) {
            executorPath = ROOT_EXECUTOR_PATH;
        }
        while (!executorPath.isEmpty() && !this._availableExecutorPaths.contains(executorPath)) {
            int index = executorPath.lastIndexOf(ROOT_EXECUTOR_PATH);
            executorPath = executorPath.substring(0, index);
        }
        if (!executorPath.isEmpty()) {
            return executorPath;
        }
        return ROOT_EXECUTOR_PATH;
    }

    public List<String> getNextExecutorsPaths(String path) {
        ArrayList<String> nextExecutorsPaths = new ArrayList<String>();
        String executorPath = this.getExecutorPath(path);
        for (String availablePath : this._availableExecutorPaths) {
            if (!this.isNextExecutorPath(availablePath, executorPath)) continue;
            nextExecutorsPaths.add(availablePath);
        }
        Collections.sort(nextExecutorsPaths);
        return nextExecutorsPaths;
    }

    protected boolean isNextExecutorPath(String path, String matchingExecutorPath) {
        String nextExecutorPath;
        String currentExecutorPath = matchingExecutorPath;
        if (!currentExecutorPath.equals(ROOT_EXECUTOR_PATH)) {
            currentExecutorPath = currentExecutorPath + ROOT_EXECUTOR_PATH;
        }
        return !(nextExecutorPath = path.replaceFirst(currentExecutorPath, "")).isEmpty() && !nextExecutorPath.contains(ROOT_EXECUTOR_PATH);
    }
}

