/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.saml.persistence.exception.NoSuchSpSessionException;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlPeerBindingLocalService;
import com.liferay.saml.persistence.service.base.SamlSpSessionLocalServiceBaseImpl;
import com.liferay.saml.persistence.service.persistence.SamlPeerBindingPersistence;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlSpSession"}, service={AopService.class})
public class SamlSpSessionLocalServiceImpl
extends SamlSpSessionLocalServiceBaseImpl {
    @Reference
    private SamlPeerBindingLocalService _samlPeerBindingLocalService;
    @Reference
    private SamlPeerBindingPersistence _samlPeerBindingPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public SamlSpSession addSamlSpSession(String assertionXml, String jSessionId, String nameIdFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, String nameIdValue, String samlIdpEntityId, String samlSpSessionKey, String sessionIndex, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUserById(serviceContext.getUserId());
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.fetchSamlPeerBinding(user.getCompanyId(), samlIdpEntityId, false, nameIdFormat, nameIdNameQualifier, nameIdValue);
        if (samlPeerBinding != null && user.getUserId() != samlPeerBinding.getUserId()) {
            samlPeerBinding.setDeleted(true);
            this._samlPeerBindingPersistence.update((BaseModel)samlPeerBinding);
            samlPeerBinding = null;
        }
        if (samlPeerBinding == null) {
            this._deleteSamlPeerBindings(this._samlPeerBindingLocalService.getUserSamlPeerBindings(user.getUserId(), samlIdpEntityId, false, nameIdFormat, nameIdNameQualifier));
            samlPeerBinding = this._samlPeerBindingLocalService.addSamlPeerBinding(user.getUserId(), samlIdpEntityId, nameIdFormat, nameIdNameQualifier, nameIdSPNameQualifier, null, nameIdValue);
        }
        long samlSpSessionId = this.counterLocalService.increment(SamlSpSession.class.getName());
        SamlSpSession samlSpSession = this.samlSpSessionPersistence.create(samlSpSessionId);
        samlSpSession.setCompanyId(user.getCompanyId());
        samlSpSession.setUserId(user.getUserId());
        samlSpSession.setUserName(user.getFullName());
        samlSpSession.setSamlPeerBindingId(samlPeerBinding.getSamlPeerBindingId());
        samlSpSession.setAssertionXml(assertionXml);
        samlSpSession.setJSessionId(jSessionId);
        samlSpSession.setSamlSpSessionKey(samlSpSessionKey);
        samlSpSession.setSessionIndex(sessionIndex);
        samlSpSession.setTerminated(false);
        return (SamlSpSession)this.samlSpSessionPersistence.update((BaseModel)samlSpSession);
    }

    public SamlSpSession fetchSamlSpSessionByJSessionId(String jSessionId) {
        return this.samlSpSessionPersistence.fetchByJSessionId(jSessionId);
    }

    public SamlSpSession fetchSamlSpSessionBySamlSpSessionKey(String samlSpSessionKey) {
        return this.samlSpSessionPersistence.fetchBySamlSpSessionKey(samlSpSessionKey);
    }

    public SamlSpSession fetchSamlSpSessionBySessionIndex(long companyId, String sessionIndex) {
        if (Validator.isNull((String)sessionIndex)) {
            return null;
        }
        return this.samlSpSessionPersistence.fetchByC_SI_First(companyId, sessionIndex, null);
    }

    public List<SamlSpSession> fetchSamlSpSessionsBySessionIndex(long companyId, String sessionIndex) {
        if (Validator.isNull((String)sessionIndex)) {
            return null;
        }
        return this.samlSpSessionPersistence.findByC_SI(companyId, sessionIndex);
    }

    public SamlSpSession getSamlSpSessionByJSessionId(String jSessionId) throws PortalException {
        return this.samlSpSessionPersistence.findByJSessionId(jSessionId);
    }

    public SamlSpSession getSamlSpSessionBySamlSpSessionKey(String samlSpSessionKey) throws PortalException {
        return this.samlSpSessionPersistence.findBySamlSpSessionKey(samlSpSessionKey);
    }

    public SamlSpSession getSamlSpSessionBySessionIndex(long companyId, String sessionIndex) throws PortalException {
        if (Validator.isNull((String)sessionIndex)) {
            throw new NoSuchSpSessionException(sessionIndex);
        }
        return this.samlSpSessionPersistence.findByC_SI_First(companyId, sessionIndex, null);
    }

    public List<SamlSpSession> getSamlSpSessions(long companyId, String nameIdFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, String nameIdValue, String samlIdpEntityId) {
        ArrayList<SamlSpSession> samlSpSessions = new ArrayList<SamlSpSession>();
        for (SamlPeerBinding samlPeerBinding : this._samlPeerBindingLocalService.getSamlPeerBindings(companyId, samlIdpEntityId, false, nameIdFormat, nameIdNameQualifier, nameIdValue)) {
            samlSpSessions.addAll(this.samlSpSessionPersistence.findBySamlPeerBindingId(samlPeerBinding.getSamlPeerBindingId()));
        }
        for (SamlPeerBinding samlPeerBinding : this._samlPeerBindingLocalService.getSamlPeerBindings(companyId, samlIdpEntityId, true, nameIdFormat, nameIdNameQualifier, nameIdValue)) {
            samlSpSessions.addAll(this.samlSpSessionPersistence.findBySamlPeerBindingId(samlPeerBinding.getSamlPeerBindingId()));
        }
        return samlSpSessions;
    }

    public SamlSpSession updateSamlSpSession(long samlSpSessionId, String jSessionId) throws PortalException {
        SamlSpSession samlSpSession = this.samlSpSessionPersistence.findByPrimaryKey(samlSpSessionId);
        samlSpSession.setModifiedDate(new Date());
        samlSpSession.setJSessionId(jSessionId);
        return (SamlSpSession)this.samlSpSessionPersistence.update((BaseModel)samlSpSession);
    }

    public SamlSpSession updateSamlSpSession(long samlSpSessionId, String assertionXml, String jSessionId, String nameIdFormat, String nameIdNameQualifier, String nameIdSPNameQualifier, String nameIdValue, String samlIdpEntityId, String samlSpSessionKey, String sessionIndex, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUserById(serviceContext.getUserId());
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.fetchSamlPeerBinding(user.getCompanyId(), samlIdpEntityId, false, nameIdFormat, nameIdNameQualifier, nameIdValue);
        if (samlPeerBinding == null) {
            samlPeerBinding = this._samlPeerBindingLocalService.addSamlPeerBinding(user.getUserId(), samlIdpEntityId, nameIdFormat, nameIdNameQualifier, nameIdSPNameQualifier, null, nameIdValue);
        }
        SamlSpSession samlSpSession = this.samlSpSessionPersistence.findByPrimaryKey(samlSpSessionId);
        samlSpSession.setCompanyId(user.getCompanyId());
        samlSpSession.setUserId(user.getUserId());
        samlSpSession.setUserName(user.getFullName());
        samlSpSession.setModifiedDate(new Date());
        samlSpSession.setSamlPeerBindingId(samlPeerBinding.getSamlPeerBindingId());
        samlSpSession.setAssertionXml(assertionXml);
        samlSpSession.setJSessionId(jSessionId);
        samlSpSession.setSamlSpSessionKey(samlSpSessionKey);
        samlSpSession.setSessionIndex(sessionIndex);
        return (SamlSpSession)this.samlSpSessionPersistence.update((BaseModel)samlSpSession);
    }

    private void _deleteSamlPeerBindings(List<SamlPeerBinding> samlPeerBindings) {
        for (SamlPeerBinding samlPeerBinding : samlPeerBindings) {
            samlPeerBinding.setDeleted(true);
            this._samlPeerBindingPersistence.update((BaseModel)samlPeerBinding);
        }
    }
}

