/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.saml.persistence.exception.DuplicateSamlIdpSpSessionException;
import com.liferay.saml.persistence.exception.NoSuchIdpSpSessionException;
import com.liferay.saml.persistence.model.SamlIdpSpSession;
import com.liferay.saml.persistence.model.SamlPeerBinding;
import com.liferay.saml.persistence.service.SamlPeerBindingLocalService;
import com.liferay.saml.persistence.service.base.SamlIdpSpSessionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.saml.persistence.model.SamlIdpSpSession"}, service={AopService.class})
public class SamlIdpSpSessionLocalServiceImpl
extends SamlIdpSpSessionLocalServiceBaseImpl {
    @Reference
    private SamlPeerBindingLocalService _samlPeerBindingLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public SamlIdpSpSession addSamlIdpSpSession(long samlIdpSsoSessionId, String samlSpEntityId, String nameIdFormat, String nameIdValue, ServiceContext serviceContext) throws PortalException {
        SamlIdpSpSession samlIdpSpSession = this._fetchSamlIdpSpSession(samlIdpSsoSessionId, samlSpEntityId);
        if (samlIdpSpSession != null) {
            throw new DuplicateSamlIdpSpSessionException(StringBundler.concat((Object[])new Object[]{"Duplicate SAML IDP SP session ", samlIdpSsoSessionId, " for ", samlSpEntityId}));
        }
        User user = this._userLocalService.getUserById(serviceContext.getUserId());
        SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.fetchSamlPeerBinding(user.getCompanyId(), samlSpEntityId, false, nameIdFormat, null, nameIdValue);
        if (samlPeerBinding == null) {
            samlPeerBinding = this._samlPeerBindingLocalService.addSamlPeerBinding(user.getUserId(), samlSpEntityId, nameIdFormat, null, null, null, nameIdValue);
        }
        long samlIdpSpSessionId = this.counterLocalService.increment(SamlIdpSpSession.class.getName());
        samlIdpSpSession = this.samlIdpSpSessionPersistence.create(samlIdpSpSessionId);
        samlIdpSpSession.setCompanyId(user.getCompanyId());
        samlIdpSpSession.setUserId(user.getUserId());
        samlIdpSpSession.setUserName(user.getFullName());
        samlIdpSpSession.setSamlIdpSsoSessionId(samlIdpSsoSessionId);
        samlIdpSpSession.setSamlPeerBindingId(samlPeerBinding.getSamlPeerBindingId());
        return (SamlIdpSpSession)this.samlIdpSpSessionPersistence.update((BaseModel)samlIdpSpSession);
    }

    public SamlIdpSpSession getSamlIdpSpSession(long samlIdpSsoSessionId, String samlSpEntityId) throws PortalException {
        SamlIdpSpSession samlIdpSpSession = this._fetchSamlIdpSpSession(samlIdpSsoSessionId, samlSpEntityId);
        if (samlIdpSpSession == null) {
            throw new NoSuchIdpSpSessionException();
        }
        return samlIdpSpSession;
    }

    public List<SamlIdpSpSession> getSamlIdpSpSessions(long samlIdpSsoSessionId) {
        return this.samlIdpSpSessionPersistence.findBySamlIdpSsoSessionId(samlIdpSsoSessionId);
    }

    public SamlIdpSpSession updateModifiedDate(long samlIdpSsoSessionId, String samlSpEntityId) throws PortalException {
        SamlIdpSpSession samlIdpSpSession = this.getSamlIdpSpSession(samlIdpSsoSessionId, samlSpEntityId);
        samlIdpSpSession.setModifiedDate(new Date());
        return (SamlIdpSpSession)this.samlIdpSpSessionPersistence.update((BaseModel)samlIdpSpSession);
    }

    private SamlIdpSpSession _fetchSamlIdpSpSession(long samlIdpSsoSessionId, String samlSpEntityId) {
        List samlIdpSsoSessions = this.samlIdpSpSessionPersistence.findBySamlIdpSsoSessionId(samlIdpSsoSessionId);
        if (samlIdpSsoSessions.isEmpty()) {
            return null;
        }
        for (SamlIdpSpSession samlIdpSsoSession : samlIdpSsoSessions) {
            SamlPeerBinding samlPeerBinding = this._samlPeerBindingLocalService.fetchSamlPeerBinding(samlIdpSsoSession.getSamlPeerBindingId());
            if (!Objects.equals(samlSpEntityId, samlPeerBinding.getSamlPeerEntityId())) continue;
            return samlIdpSsoSession;
        }
        return null;
    }
}

