/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saml.persistence.model.impl;

import com.liferay.saml.persistence.model.SamlSpSession;
import com.liferay.saml.persistence.service.SamlSpSessionLocalServiceUtil;

/**
 * The extended model base implementation for the SamlSpSession service. Represents a row in the &quot;SamlSpSession&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SamlSpSessionImpl}.
 * </p>
 *
 * @author Mika Koivisto
 * @see SamlSpSessionImpl
 * @see SamlSpSession
 * @generated
 */
public abstract class SamlSpSessionBaseImpl
	extends SamlSpSessionModelImpl implements SamlSpSession {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saml sp session model instance should use the <code>SamlSpSession</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SamlSpSessionLocalServiceUtil.addSamlSpSession(this);
		}
		else {
			SamlSpSessionLocalServiceUtil.updateSamlSpSession(this);
		}
	}

}