/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.saml.persistence.internal.upgrade.v3_0_1;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.OrderedProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.function.BiConsumer;

public class SamlSpIdpConnectionDataUpgradeProcess
extends UpgradeProcess {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpgrade() throws Exception {
        try (Statement statement = this.connection.createStatement();
             ResultSet resultSet = statement.executeQuery("select samlSpIdpConnectionId, userAttributeMappings from SamlSpIdpConnection");){
            while (resultSet.next()) {
                String userAttributeMappings = resultSet.getString("userAttributeMappings");
                if (Validator.isNull((String)userAttributeMappings)) continue;
                OrderedProperties userAttributeMappingsProperties = new OrderedProperties();
                userAttributeMappingsProperties.load((Reader)new UnsyncStringReader(userAttributeMappings));
                userAttributeMappingsProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(arg_0, arg_1) -> SamlSpIdpConnectionDataUpgradeProcess.lambda$doUpgrade$0((Properties)userAttributeMappingsProperties, arg_0, arg_1)));
                try (StringWriter stringWriter = new StringWriter();){
                    userAttributeMappingsProperties.store(stringWriter, null);
                    PreparedStatement preparedStatement = this.connection.prepareStatement("update SamlSpIdpConnection set userAttributeMappings = ? where samlSpIdpConnectionId =  ?");
                    try {
                        preparedStatement.setString(1, stringWriter.toString());
                        preparedStatement.setLong(2, resultSet.getLong("samlSpIdpConnectionId"));
                        preparedStatement.execute();
                    }
                    finally {
                        if (preparedStatement == null) continue;
                        preparedStatement.close();
                    }
                }
            }
            return;
        }
    }

    private static /* synthetic */ void lambda$doUpgrade$0(Properties userAttributeMappingsProperties, Object key, Object value) {
        if (Validator.isNull((Object)value)) {
            userAttributeMappingsProperties.replace(key, key);
        }
    }
}

