/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.internal.messaging;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.push.notifications.internal.messaging.PushNotificationsMessageListener;
import com.liferay.push.notifications.internal.messaging.PushNotificationsResponseMessageListener;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PushNotificationMessagingConfigurator.class})
public class PushNotificationMessagingConfigurator {
    private BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PushNotificationsDeviceLocalService _pushNotificationsDeviceLocalService;
    private final Map<String, ServiceRegistration<Destination>> _serviceRegistrations = new HashMap<String, ServiceRegistration<Destination>>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        DestinationConfiguration pushNotificationDestinationConfiguration = new DestinationConfiguration("serial", "liferay/push_notification");
        Destination pushNotificationDestination = this.registerDestination(pushNotificationDestinationConfiguration);
        PushNotificationsMessageListener pushNotificationsMessageListener = new PushNotificationsMessageListener(this._pushNotificationsDeviceLocalService);
        pushNotificationDestination.register((MessageListener)pushNotificationsMessageListener);
        DestinationConfiguration pushNotificationResponseDestinationConfiguration = new DestinationConfiguration("serial", "liferay/push_notification_response");
        Destination pushNotificationResponseDestination = this.registerDestination(pushNotificationResponseDestinationConfiguration);
        PushNotificationsResponseMessageListener pushNotificationsResponseMessageListener = new PushNotificationsResponseMessageListener(this._jsonFactory);
        pushNotificationResponseDestination.register((MessageListener)pushNotificationsResponseMessageListener);
    }

    @Deactivate
    protected void deactivate() {
        if (!this._serviceRegistrations.isEmpty()) {
            for (ServiceRegistration<Destination> serviceRegistration : this._serviceRegistrations.values()) {
                Destination destination = (Destination)this._bundleContext.getService(serviceRegistration.getReference());
                serviceRegistration.unregister();
                destination.destroy();
            }
            this._serviceRegistrations.clear();
        }
        this._bundleContext = null;
    }

    protected Destination registerDestination(DestinationConfiguration destinationConfiguration) {
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("destination.name", destination.getName());
        ServiceRegistration serviceRegistration = this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        this._serviceRegistrations.put(destination.getName(), (ServiceRegistration<Destination>)serviceRegistration);
        return destination;
    }
}

