/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.workflow.metrics.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionModel;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the WorkflowMetricsSLADefinition service. Represents a row in the &quot;WMSLADefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>WorkflowMetricsSLADefinitionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WorkflowMetricsSLADefinitionImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WorkflowMetricsSLADefinitionImpl
 * @generated
 */
public class WorkflowMetricsSLADefinitionModelImpl
	extends BaseModelImpl<WorkflowMetricsSLADefinition>
	implements WorkflowMetricsSLADefinitionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a workflow metrics sla definition model instance should use the <code>WorkflowMetricsSLADefinition</code> interface instead.
	 */
	public static final String TABLE_NAME = "WMSLADefinition";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"wmSLADefinitionId", Types.BIGINT}, {"groupId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"active_", Types.BOOLEAN},
		{"calendarKey", Types.VARCHAR}, {"description", Types.CLOB},
		{"duration", Types.BIGINT}, {"name", Types.VARCHAR},
		{"pauseNodeKeys", Types.VARCHAR}, {"processId", Types.BIGINT},
		{"processVersion", Types.VARCHAR}, {"startNodeKeys", Types.VARCHAR},
		{"stopNodeKeys", Types.VARCHAR}, {"version", Types.VARCHAR},
		{"status", Types.INTEGER}, {"statusByUserId", Types.BIGINT},
		{"statusByUserName", Types.VARCHAR}, {"statusDate", Types.TIMESTAMP}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("wmSLADefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("groupId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("calendarKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.CLOB);
		TABLE_COLUMNS_MAP.put("duration", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pauseNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("processId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("processVersion", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("startNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("stopNodeKeys", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("statusByUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("statusByUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("statusDate", Types.TIMESTAMP);
	}

	public static final String TABLE_SQL_CREATE =
		"create table WMSLADefinition (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,wmSLADefinitionId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,active_ BOOLEAN,calendarKey VARCHAR(75) null,description TEXT null,duration LONG,name VARCHAR(75) null,pauseNodeKeys VARCHAR(75) null,processId LONG,processVersion VARCHAR(75) null,startNodeKeys VARCHAR(75) null,stopNodeKeys VARCHAR(75) null,version VARCHAR(75) null,status INTEGER,statusByUserId LONG,statusByUserName VARCHAR(75) null,statusDate DATE null)";

	public static final String TABLE_SQL_DROP = "drop table WMSLADefinition";

	public static final String ORDER_BY_JPQL =
		" ORDER BY workflowMetricsSLADefinition.modifiedDate DESC";

	public static final String ORDER_BY_SQL =
		" ORDER BY WMSLADefinition.modifiedDate DESC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long GROUPID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PROCESSID_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PROCESSVERSION_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long WORKFLOWMETRICSSLADEFINITIONID_COLUMN_BITMASK =
		256L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDDATE_COLUMN_BITMASK = 512L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public WorkflowMetricsSLADefinitionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _workflowMetricsSLADefinitionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setWorkflowMetricsSLADefinitionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _workflowMetricsSLADefinitionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return WorkflowMetricsSLADefinition.class;
	}

	@Override
	public String getModelClassName() {
		return WorkflowMetricsSLADefinition.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<WorkflowMetricsSLADefinition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<WorkflowMetricsSLADefinition, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WorkflowMetricsSLADefinition, Object>
				attributeGetterFunction = entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply(
					(WorkflowMetricsSLADefinition)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<WorkflowMetricsSLADefinition, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<WorkflowMetricsSLADefinition, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(WorkflowMetricsSLADefinition)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<WorkflowMetricsSLADefinition, Object>>
		getAttributeGetterFunctions() {

		return AttributeGetterFunctionsHolder._attributeGetterFunctions;
	}

	public Map<String, BiConsumer<WorkflowMetricsSLADefinition, Object>>
		getAttributeSetterBiConsumers() {

		return AttributeSetterBiConsumersHolder._attributeSetterBiConsumers;
	}

	private static class AttributeGetterFunctionsHolder {

		private static final Map
			<String, Function<WorkflowMetricsSLADefinition, Object>>
				_attributeGetterFunctions;

		static {
			Map<String, Function<WorkflowMetricsSLADefinition, Object>>
				attributeGetterFunctions =
					new LinkedHashMap
						<String,
						 Function<WorkflowMetricsSLADefinition, Object>>();

			attributeGetterFunctions.put(
				"mvccVersion", WorkflowMetricsSLADefinition::getMvccVersion);
			attributeGetterFunctions.put(
				"uuid", WorkflowMetricsSLADefinition::getUuid);
			attributeGetterFunctions.put(
				"workflowMetricsSLADefinitionId",
				WorkflowMetricsSLADefinition::
					getWorkflowMetricsSLADefinitionId);
			attributeGetterFunctions.put(
				"groupId", WorkflowMetricsSLADefinition::getGroupId);
			attributeGetterFunctions.put(
				"companyId", WorkflowMetricsSLADefinition::getCompanyId);
			attributeGetterFunctions.put(
				"userId", WorkflowMetricsSLADefinition::getUserId);
			attributeGetterFunctions.put(
				"userName", WorkflowMetricsSLADefinition::getUserName);
			attributeGetterFunctions.put(
				"createDate", WorkflowMetricsSLADefinition::getCreateDate);
			attributeGetterFunctions.put(
				"modifiedDate", WorkflowMetricsSLADefinition::getModifiedDate);
			attributeGetterFunctions.put(
				"active", WorkflowMetricsSLADefinition::getActive);
			attributeGetterFunctions.put(
				"calendarKey", WorkflowMetricsSLADefinition::getCalendarKey);
			attributeGetterFunctions.put(
				"description", WorkflowMetricsSLADefinition::getDescription);
			attributeGetterFunctions.put(
				"duration", WorkflowMetricsSLADefinition::getDuration);
			attributeGetterFunctions.put(
				"name", WorkflowMetricsSLADefinition::getName);
			attributeGetterFunctions.put(
				"pauseNodeKeys",
				WorkflowMetricsSLADefinition::getPauseNodeKeys);
			attributeGetterFunctions.put(
				"processId", WorkflowMetricsSLADefinition::getProcessId);
			attributeGetterFunctions.put(
				"processVersion",
				WorkflowMetricsSLADefinition::getProcessVersion);
			attributeGetterFunctions.put(
				"startNodeKeys",
				WorkflowMetricsSLADefinition::getStartNodeKeys);
			attributeGetterFunctions.put(
				"stopNodeKeys", WorkflowMetricsSLADefinition::getStopNodeKeys);
			attributeGetterFunctions.put(
				"version", WorkflowMetricsSLADefinition::getVersion);
			attributeGetterFunctions.put(
				"status", WorkflowMetricsSLADefinition::getStatus);
			attributeGetterFunctions.put(
				"statusByUserId",
				WorkflowMetricsSLADefinition::getStatusByUserId);
			attributeGetterFunctions.put(
				"statusByUserName",
				WorkflowMetricsSLADefinition::getStatusByUserName);
			attributeGetterFunctions.put(
				"statusDate", WorkflowMetricsSLADefinition::getStatusDate);

			_attributeGetterFunctions = Collections.unmodifiableMap(
				attributeGetterFunctions);
		}

	}

	private static class AttributeSetterBiConsumersHolder {

		private static final Map
			<String, BiConsumer<WorkflowMetricsSLADefinition, Object>>
				_attributeSetterBiConsumers;

		static {
			Map<String, BiConsumer<WorkflowMetricsSLADefinition, ?>>
				attributeSetterBiConsumers =
					new LinkedHashMap
						<String, BiConsumer<WorkflowMetricsSLADefinition, ?>>();

			attributeSetterBiConsumers.put(
				"mvccVersion",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setMvccVersion);
			attributeSetterBiConsumers.put(
				"uuid",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setUuid);
			attributeSetterBiConsumers.put(
				"workflowMetricsSLADefinitionId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::
						setWorkflowMetricsSLADefinitionId);
			attributeSetterBiConsumers.put(
				"groupId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setGroupId);
			attributeSetterBiConsumers.put(
				"companyId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setCompanyId);
			attributeSetterBiConsumers.put(
				"userId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setUserId);
			attributeSetterBiConsumers.put(
				"userName",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setUserName);
			attributeSetterBiConsumers.put(
				"createDate",
				(BiConsumer<WorkflowMetricsSLADefinition, Date>)
					WorkflowMetricsSLADefinition::setCreateDate);
			attributeSetterBiConsumers.put(
				"modifiedDate",
				(BiConsumer<WorkflowMetricsSLADefinition, Date>)
					WorkflowMetricsSLADefinition::setModifiedDate);
			attributeSetterBiConsumers.put(
				"active",
				(BiConsumer<WorkflowMetricsSLADefinition, Boolean>)
					WorkflowMetricsSLADefinition::setActive);
			attributeSetterBiConsumers.put(
				"calendarKey",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setCalendarKey);
			attributeSetterBiConsumers.put(
				"description",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setDescription);
			attributeSetterBiConsumers.put(
				"duration",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setDuration);
			attributeSetterBiConsumers.put(
				"name",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setName);
			attributeSetterBiConsumers.put(
				"pauseNodeKeys",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setPauseNodeKeys);
			attributeSetterBiConsumers.put(
				"processId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setProcessId);
			attributeSetterBiConsumers.put(
				"processVersion",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setProcessVersion);
			attributeSetterBiConsumers.put(
				"startNodeKeys",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setStartNodeKeys);
			attributeSetterBiConsumers.put(
				"stopNodeKeys",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setStopNodeKeys);
			attributeSetterBiConsumers.put(
				"version",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setVersion);
			attributeSetterBiConsumers.put(
				"status",
				(BiConsumer<WorkflowMetricsSLADefinition, Integer>)
					WorkflowMetricsSLADefinition::setStatus);
			attributeSetterBiConsumers.put(
				"statusByUserId",
				(BiConsumer<WorkflowMetricsSLADefinition, Long>)
					WorkflowMetricsSLADefinition::setStatusByUserId);
			attributeSetterBiConsumers.put(
				"statusByUserName",
				(BiConsumer<WorkflowMetricsSLADefinition, String>)
					WorkflowMetricsSLADefinition::setStatusByUserName);
			attributeSetterBiConsumers.put(
				"statusDate",
				(BiConsumer<WorkflowMetricsSLADefinition, Date>)
					WorkflowMetricsSLADefinition::setStatusDate);

			_attributeSetterBiConsumers = Collections.unmodifiableMap(
				(Map)attributeSetterBiConsumers);
		}

	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@Override
	public long getWorkflowMetricsSLADefinitionId() {
		return _workflowMetricsSLADefinitionId;
	}

	@Override
	public void setWorkflowMetricsSLADefinitionId(
		long workflowMetricsSLADefinitionId) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_workflowMetricsSLADefinitionId = workflowMetricsSLADefinitionId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalWorkflowMetricsSLADefinitionId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("wmSLADefinitionId"));
	}

	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_groupId = groupId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalGroupId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("groupId"));
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public boolean getActive() {
		return _active;
	}

	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@Override
	public String getCalendarKey() {
		if (_calendarKey == null) {
			return "";
		}
		else {
			return _calendarKey;
		}
	}

	@Override
	public void setCalendarKey(String calendarKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_calendarKey = calendarKey;
	}

	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@Override
	public long getDuration() {
		return _duration;
	}

	@Override
	public void setDuration(long duration) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_duration = duration;
	}

	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@Override
	public String getPauseNodeKeys() {
		if (_pauseNodeKeys == null) {
			return "";
		}
		else {
			return _pauseNodeKeys;
		}
	}

	@Override
	public void setPauseNodeKeys(String pauseNodeKeys) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_pauseNodeKeys = pauseNodeKeys;
	}

	@Override
	public long getProcessId() {
		return _processId;
	}

	@Override
	public void setProcessId(long processId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_processId = processId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalProcessId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("processId"));
	}

	@Override
	public String getProcessVersion() {
		if (_processVersion == null) {
			return "";
		}
		else {
			return _processVersion;
		}
	}

	@Override
	public void setProcessVersion(String processVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_processVersion = processVersion;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalProcessVersion() {
		return getColumnOriginalValue("processVersion");
	}

	@Override
	public String getStartNodeKeys() {
		if (_startNodeKeys == null) {
			return "";
		}
		else {
			return _startNodeKeys;
		}
	}

	@Override
	public void setStartNodeKeys(String startNodeKeys) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_startNodeKeys = startNodeKeys;
	}

	@Override
	public String getStopNodeKeys() {
		if (_stopNodeKeys == null) {
			return "";
		}
		else {
			return _stopNodeKeys;
		}
	}

	@Override
	public void setStopNodeKeys(String stopNodeKeys) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_stopNodeKeys = stopNodeKeys;
	}

	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@Override
	public long getStatusByUserId() {
		return _statusByUserId;
	}

	@Override
	public void setStatusByUserId(long statusByUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserId = statusByUserId;
	}

	@Override
	public String getStatusByUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getStatusByUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setStatusByUserUuid(String statusByUserUuid) {
	}

	@Override
	public String getStatusByUserName() {
		if (_statusByUserName == null) {
			return "";
		}
		else {
			return _statusByUserName;
		}
	}

	@Override
	public void setStatusByUserName(String statusByUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusByUserName = statusByUserName;
	}

	@Override
	public Date getStatusDate() {
		return _statusDate;
	}

	@Override
	public void setStatusDate(Date statusDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_statusDate = statusDate;
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(
				WorkflowMetricsSLADefinition.class.getName()));
	}

	@Override
	public boolean isApproved() {
		if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDenied() {
		if (getStatus() == WorkflowConstants.STATUS_DENIED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isDraft() {
		if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isExpired() {
		if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isInactive() {
		if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isIncomplete() {
		if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isPending() {
		if (getStatus() == WorkflowConstants.STATUS_PENDING) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public boolean isScheduled() {
		if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
			return true;
		}
		else {
			return false;
		}
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), WorkflowMetricsSLADefinition.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public WorkflowMetricsSLADefinition toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, WorkflowMetricsSLADefinition>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		WorkflowMetricsSLADefinitionImpl workflowMetricsSLADefinitionImpl =
			new WorkflowMetricsSLADefinitionImpl();

		workflowMetricsSLADefinitionImpl.setMvccVersion(getMvccVersion());
		workflowMetricsSLADefinitionImpl.setUuid(getUuid());
		workflowMetricsSLADefinitionImpl.setWorkflowMetricsSLADefinitionId(
			getWorkflowMetricsSLADefinitionId());
		workflowMetricsSLADefinitionImpl.setGroupId(getGroupId());
		workflowMetricsSLADefinitionImpl.setCompanyId(getCompanyId());
		workflowMetricsSLADefinitionImpl.setUserId(getUserId());
		workflowMetricsSLADefinitionImpl.setUserName(getUserName());
		workflowMetricsSLADefinitionImpl.setCreateDate(getCreateDate());
		workflowMetricsSLADefinitionImpl.setModifiedDate(getModifiedDate());
		workflowMetricsSLADefinitionImpl.setActive(isActive());
		workflowMetricsSLADefinitionImpl.setCalendarKey(getCalendarKey());
		workflowMetricsSLADefinitionImpl.setDescription(getDescription());
		workflowMetricsSLADefinitionImpl.setDuration(getDuration());
		workflowMetricsSLADefinitionImpl.setName(getName());
		workflowMetricsSLADefinitionImpl.setPauseNodeKeys(getPauseNodeKeys());
		workflowMetricsSLADefinitionImpl.setProcessId(getProcessId());
		workflowMetricsSLADefinitionImpl.setProcessVersion(getProcessVersion());
		workflowMetricsSLADefinitionImpl.setStartNodeKeys(getStartNodeKeys());
		workflowMetricsSLADefinitionImpl.setStopNodeKeys(getStopNodeKeys());
		workflowMetricsSLADefinitionImpl.setVersion(getVersion());
		workflowMetricsSLADefinitionImpl.setStatus(getStatus());
		workflowMetricsSLADefinitionImpl.setStatusByUserId(getStatusByUserId());
		workflowMetricsSLADefinitionImpl.setStatusByUserName(
			getStatusByUserName());
		workflowMetricsSLADefinitionImpl.setStatusDate(getStatusDate());

		workflowMetricsSLADefinitionImpl.resetOriginalValues();

		return workflowMetricsSLADefinitionImpl;
	}

	@Override
	public WorkflowMetricsSLADefinition cloneWithOriginalValues() {
		WorkflowMetricsSLADefinitionImpl workflowMetricsSLADefinitionImpl =
			new WorkflowMetricsSLADefinitionImpl();

		workflowMetricsSLADefinitionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		workflowMetricsSLADefinitionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		workflowMetricsSLADefinitionImpl.setWorkflowMetricsSLADefinitionId(
			this.<Long>getColumnOriginalValue("wmSLADefinitionId"));
		workflowMetricsSLADefinitionImpl.setGroupId(
			this.<Long>getColumnOriginalValue("groupId"));
		workflowMetricsSLADefinitionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		workflowMetricsSLADefinitionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		workflowMetricsSLADefinitionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		workflowMetricsSLADefinitionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		workflowMetricsSLADefinitionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		workflowMetricsSLADefinitionImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		workflowMetricsSLADefinitionImpl.setCalendarKey(
			this.<String>getColumnOriginalValue("calendarKey"));
		workflowMetricsSLADefinitionImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		workflowMetricsSLADefinitionImpl.setDuration(
			this.<Long>getColumnOriginalValue("duration"));
		workflowMetricsSLADefinitionImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		workflowMetricsSLADefinitionImpl.setPauseNodeKeys(
			this.<String>getColumnOriginalValue("pauseNodeKeys"));
		workflowMetricsSLADefinitionImpl.setProcessId(
			this.<Long>getColumnOriginalValue("processId"));
		workflowMetricsSLADefinitionImpl.setProcessVersion(
			this.<String>getColumnOriginalValue("processVersion"));
		workflowMetricsSLADefinitionImpl.setStartNodeKeys(
			this.<String>getColumnOriginalValue("startNodeKeys"));
		workflowMetricsSLADefinitionImpl.setStopNodeKeys(
			this.<String>getColumnOriginalValue("stopNodeKeys"));
		workflowMetricsSLADefinitionImpl.setVersion(
			this.<String>getColumnOriginalValue("version"));
		workflowMetricsSLADefinitionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));
		workflowMetricsSLADefinitionImpl.setStatusByUserId(
			this.<Long>getColumnOriginalValue("statusByUserId"));
		workflowMetricsSLADefinitionImpl.setStatusByUserName(
			this.<String>getColumnOriginalValue("statusByUserName"));
		workflowMetricsSLADefinitionImpl.setStatusDate(
			this.<Date>getColumnOriginalValue("statusDate"));

		return workflowMetricsSLADefinitionImpl;
	}

	@Override
	public int compareTo(
		WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {

		int value = 0;

		value = DateUtil.compareTo(
			getModifiedDate(), workflowMetricsSLADefinition.getModifiedDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof WorkflowMetricsSLADefinition)) {
			return false;
		}

		WorkflowMetricsSLADefinition workflowMetricsSLADefinition =
			(WorkflowMetricsSLADefinition)object;

		long primaryKey = workflowMetricsSLADefinition.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<WorkflowMetricsSLADefinition> toCacheModel() {
		WorkflowMetricsSLADefinitionCacheModel
			workflowMetricsSLADefinitionCacheModel =
				new WorkflowMetricsSLADefinitionCacheModel();

		workflowMetricsSLADefinitionCacheModel.mvccVersion = getMvccVersion();

		workflowMetricsSLADefinitionCacheModel.uuid = getUuid();

		String uuid = workflowMetricsSLADefinitionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.uuid = null;
		}

		workflowMetricsSLADefinitionCacheModel.workflowMetricsSLADefinitionId =
			getWorkflowMetricsSLADefinitionId();

		workflowMetricsSLADefinitionCacheModel.groupId = getGroupId();

		workflowMetricsSLADefinitionCacheModel.companyId = getCompanyId();

		workflowMetricsSLADefinitionCacheModel.userId = getUserId();

		workflowMetricsSLADefinitionCacheModel.userName = getUserName();

		String userName = workflowMetricsSLADefinitionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			workflowMetricsSLADefinitionCacheModel.createDate =
				createDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			workflowMetricsSLADefinitionCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionCacheModel.modifiedDate =
				Long.MIN_VALUE;
		}

		workflowMetricsSLADefinitionCacheModel.active = isActive();

		workflowMetricsSLADefinitionCacheModel.calendarKey = getCalendarKey();

		String calendarKey = workflowMetricsSLADefinitionCacheModel.calendarKey;

		if ((calendarKey != null) && (calendarKey.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.calendarKey = null;
		}

		workflowMetricsSLADefinitionCacheModel.description = getDescription();

		String description = workflowMetricsSLADefinitionCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.description = null;
		}

		workflowMetricsSLADefinitionCacheModel.duration = getDuration();

		workflowMetricsSLADefinitionCacheModel.name = getName();

		String name = workflowMetricsSLADefinitionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.name = null;
		}

		workflowMetricsSLADefinitionCacheModel.pauseNodeKeys =
			getPauseNodeKeys();

		String pauseNodeKeys =
			workflowMetricsSLADefinitionCacheModel.pauseNodeKeys;

		if ((pauseNodeKeys != null) && (pauseNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.pauseNodeKeys = null;
		}

		workflowMetricsSLADefinitionCacheModel.processId = getProcessId();

		workflowMetricsSLADefinitionCacheModel.processVersion =
			getProcessVersion();

		String processVersion =
			workflowMetricsSLADefinitionCacheModel.processVersion;

		if ((processVersion != null) && (processVersion.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.processVersion = null;
		}

		workflowMetricsSLADefinitionCacheModel.startNodeKeys =
			getStartNodeKeys();

		String startNodeKeys =
			workflowMetricsSLADefinitionCacheModel.startNodeKeys;

		if ((startNodeKeys != null) && (startNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.startNodeKeys = null;
		}

		workflowMetricsSLADefinitionCacheModel.stopNodeKeys = getStopNodeKeys();

		String stopNodeKeys =
			workflowMetricsSLADefinitionCacheModel.stopNodeKeys;

		if ((stopNodeKeys != null) && (stopNodeKeys.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.stopNodeKeys = null;
		}

		workflowMetricsSLADefinitionCacheModel.version = getVersion();

		String version = workflowMetricsSLADefinitionCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.version = null;
		}

		workflowMetricsSLADefinitionCacheModel.status = getStatus();

		workflowMetricsSLADefinitionCacheModel.statusByUserId =
			getStatusByUserId();

		workflowMetricsSLADefinitionCacheModel.statusByUserName =
			getStatusByUserName();

		String statusByUserName =
			workflowMetricsSLADefinitionCacheModel.statusByUserName;

		if ((statusByUserName != null) && (statusByUserName.length() == 0)) {
			workflowMetricsSLADefinitionCacheModel.statusByUserName = null;
		}

		Date statusDate = getStatusDate();

		if (statusDate != null) {
			workflowMetricsSLADefinitionCacheModel.statusDate =
				statusDate.getTime();
		}
		else {
			workflowMetricsSLADefinitionCacheModel.statusDate = Long.MIN_VALUE;
		}

		return workflowMetricsSLADefinitionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<WorkflowMetricsSLADefinition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<WorkflowMetricsSLADefinition, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<WorkflowMetricsSLADefinition, Object>
				attributeGetterFunction = entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(WorkflowMetricsSLADefinition)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, WorkflowMetricsSLADefinition>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						WorkflowMetricsSLADefinition.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _workflowMetricsSLADefinitionId;
	private long _groupId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private boolean _active;
	private String _calendarKey;
	private String _description;
	private long _duration;
	private String _name;
	private String _pauseNodeKeys;
	private long _processId;
	private String _processVersion;
	private String _startNodeKeys;
	private String _stopNodeKeys;
	private String _version;
	private int _status;
	private long _statusByUserId;
	private String _statusByUserName;
	private Date _statusDate;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<WorkflowMetricsSLADefinition, Object> function =
			AttributeGetterFunctionsHolder._attributeGetterFunctions.get(
				columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((WorkflowMetricsSLADefinition)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"wmSLADefinitionId", _workflowMetricsSLADefinitionId);
		_columnOriginalValues.put("groupId", _groupId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("calendarKey", _calendarKey);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("duration", _duration);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("pauseNodeKeys", _pauseNodeKeys);
		_columnOriginalValues.put("processId", _processId);
		_columnOriginalValues.put("processVersion", _processVersion);
		_columnOriginalValues.put("startNodeKeys", _startNodeKeys);
		_columnOriginalValues.put("stopNodeKeys", _stopNodeKeys);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("status", _status);
		_columnOriginalValues.put("statusByUserId", _statusByUserId);
		_columnOriginalValues.put("statusByUserName", _statusByUserName);
		_columnOriginalValues.put("statusDate", _statusDate);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put(
			"wmSLADefinitionId", "workflowMetricsSLADefinitionId");
		attributeNames.put("active_", "active");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("wmSLADefinitionId", 4L);

		columnBitmasks.put("groupId", 8L);

		columnBitmasks.put("companyId", 16L);

		columnBitmasks.put("userId", 32L);

		columnBitmasks.put("userName", 64L);

		columnBitmasks.put("createDate", 128L);

		columnBitmasks.put("modifiedDate", 256L);

		columnBitmasks.put("active_", 512L);

		columnBitmasks.put("calendarKey", 1024L);

		columnBitmasks.put("description", 2048L);

		columnBitmasks.put("duration", 4096L);

		columnBitmasks.put("name", 8192L);

		columnBitmasks.put("pauseNodeKeys", 16384L);

		columnBitmasks.put("processId", 32768L);

		columnBitmasks.put("processVersion", 65536L);

		columnBitmasks.put("startNodeKeys", 131072L);

		columnBitmasks.put("stopNodeKeys", 262144L);

		columnBitmasks.put("version", 524288L);

		columnBitmasks.put("status", 1048576L);

		columnBitmasks.put("statusByUserId", 2097152L);

		columnBitmasks.put("statusByUserName", 4194304L);

		columnBitmasks.put("statusDate", 8388608L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private WorkflowMetricsSLADefinition _escapedModel;

}