/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.service.impl;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.FilterAggregationResult;
import com.liferay.portal.search.aggregation.bucket.TermsAggregationResult;
import com.liferay.portal.search.engine.adapter.search.SearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionDuplicateNameException;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionDurationException;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionNameException;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionStartNodeKeysException;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionStopNodeKeysException;
import com.liferay.portal.workflow.metrics.exception.WorkflowMetricsSLADefinitionTimeframeException;
import com.liferay.portal.workflow.metrics.internal.petra.executor.WorkflowMetricsPortalExecutor;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAProcessResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.service.base.WorkflowMetricsSLADefinitionLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class WorkflowMetricsSLADefinitionLocalServiceImpl
extends WorkflowMetricsSLADefinitionLocalServiceBaseImpl {
    private static final String _VERSION_DEFAULT = "1.0";
    @ServiceReference(type=Aggregations.class)
    private Aggregations _aggregations;
    @ServiceReference(filterString="(workflow.metrics.index.entity.name=node)", type=WorkflowMetricsIndexNameBuilder.class)
    private WorkflowMetricsIndexNameBuilder _nodeWorkflowMetricsIndexNameBuilder;
    @ServiceReference(filterString="(workflow.metrics.index.entity.name=process)", type=WorkflowMetricsIndexNameBuilder.class)
    private WorkflowMetricsIndexNameBuilder _processWorkflowMetricsIndexNameBuilder;
    @ServiceReference(type=Queries.class)
    private Queries _queries;
    @ServiceReference(type=SearchRequestExecutor.class)
    private SearchRequestExecutor _searchRequestExecutor;
    @ServiceReference(type=SLAProcessResultWorkflowMetricsIndexer.class)
    private SLAProcessResultWorkflowMetricsIndexer _slaProcessResultWorkflowMetricsIndexer;
    @ServiceReference(type=SLATaskResultWorkflowMetricsIndexer.class)
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @ServiceReference(type=WorkflowMetricsPortalExecutor.class)
    private WorkflowMetricsPortalExecutor _workflowMetricsPortalExecutor;

    public WorkflowMetricsSLADefinition addWorkflowMetricsSLADefinition(String calendarKey, String description, long duration, String name, String[] pauseNodeKeys, long processId, String[] startNodeKeys, String[] stopNodeKeys, ServiceContext serviceContext) throws PortalException {
        String latestProcessVersion = this._getLatestProcessVersion(serviceContext.getCompanyId(), processId);
        this.validate(0L, serviceContext.getCompanyId(), processId, latestProcessVersion, name, duration, pauseNodeKeys, startNodeKeys, stopNodeKeys);
        WorkflowMetricsSLADefinition workflowMetricsSLADefinition = this.workflowMetricsSLADefinitionPersistence.create(this.counterLocalService.increment());
        workflowMetricsSLADefinition.setGroupId(serviceContext.getScopeGroupId());
        workflowMetricsSLADefinition.setCompanyId(serviceContext.getCompanyId());
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        workflowMetricsSLADefinition.setUserId(user.getUserId());
        workflowMetricsSLADefinition.setUserName(user.getFullName());
        Date now = new Date();
        workflowMetricsSLADefinition.setCreateDate(now);
        workflowMetricsSLADefinition.setModifiedDate(now);
        workflowMetricsSLADefinition.setActive(true);
        workflowMetricsSLADefinition.setCalendarKey(calendarKey);
        workflowMetricsSLADefinition.setDescription(description);
        workflowMetricsSLADefinition.setDuration(duration);
        workflowMetricsSLADefinition.setName(name);
        workflowMetricsSLADefinition.setPauseNodeKeys(StringUtil.merge((Object[])pauseNodeKeys));
        workflowMetricsSLADefinition.setProcessId(processId);
        workflowMetricsSLADefinition.setProcessVersion(latestProcessVersion);
        workflowMetricsSLADefinition.setStartNodeKeys(StringUtil.merge((Object[])startNodeKeys));
        workflowMetricsSLADefinition.setStopNodeKeys(StringUtil.merge((Object[])stopNodeKeys));
        workflowMetricsSLADefinition.setVersion(_VERSION_DEFAULT);
        workflowMetricsSLADefinition.setStatus(0);
        workflowMetricsSLADefinition = (WorkflowMetricsSLADefinition)this.workflowMetricsSLADefinitionPersistence.update((BaseModel)workflowMetricsSLADefinition);
        this.addWorkflowMetricsSLADefinitionVersion(user, workflowMetricsSLADefinition);
        return workflowMetricsSLADefinition;
    }

    public void deactivateWorkflowMetricsSLADefinition(long workflowMetricsSLADefinitionId, ServiceContext serviceContext) throws PortalException {
        WorkflowMetricsSLADefinition workflowMetricsSLADefinition = this.workflowMetricsSLADefinitionPersistence.findByPrimaryKey(workflowMetricsSLADefinitionId);
        workflowMetricsSLADefinition.setActive(false);
        workflowMetricsSLADefinition = (WorkflowMetricsSLADefinition)this.workflowMetricsSLADefinitionPersistence.update((BaseModel)workflowMetricsSLADefinition);
        this.addWorkflowMetricsSLADefinitionVersion(this.userLocalService.getUser(serviceContext.getGuestOrUserId()), workflowMetricsSLADefinition);
        long companyId = workflowMetricsSLADefinition.getCompanyId();
        long processId = workflowMetricsSLADefinition.getProcessId();
        this._workflowMetricsPortalExecutor.execute(() -> this._slaProcessResultWorkflowMetricsIndexer.deleteDocuments(companyId, processId, workflowMetricsSLADefinitionId));
        this._workflowMetricsPortalExecutor.execute(() -> this._slaTaskResultWorkflowMetricsIndexer.deleteDocuments(companyId, processId, workflowMetricsSLADefinitionId));
    }

    public WorkflowMetricsSLADefinition getWorkflowMetricsSLADefinition(long workflowMetricsSLADefinitionId, boolean active) throws PortalException {
        return this.workflowMetricsSLADefinitionPersistence.findByWMSLAD_A(workflowMetricsSLADefinitionId, active);
    }

    public List<WorkflowMetricsSLADefinition> getWorkflowMetricsSLADefinitions(long companyId, boolean active, long processId, int status, int start, int end, OrderByComparator<WorkflowMetricsSLADefinition> obc) {
        return this.workflowMetricsSLADefinitionPersistence.findByC_A_P_S(companyId, active, processId, status, start, end, obc);
    }

    public List<WorkflowMetricsSLADefinition> getWorkflowMetricsSLADefinitions(long companyId, boolean active, long processId, String processVersion, int status) {
        return this.workflowMetricsSLADefinitionPersistence.findByC_A_P_NotPV_S(companyId, active, processId, processVersion, status);
    }

    public List<WorkflowMetricsSLADefinition> getWorkflowMetricsSLADefinitions(long companyId, int status) {
        return this.workflowMetricsSLADefinitionPersistence.findByC_S(companyId, status);
    }

    public int getWorkflowMetricsSLADefinitionsCount(long companyId, boolean active, long processId) {
        return this.workflowMetricsSLADefinitionPersistence.countByC_A_P(companyId, active, processId);
    }

    public int getWorkflowMetricsSLADefinitionsCount(long companyId, boolean active, long processId, int status) {
        return this.workflowMetricsSLADefinitionPersistence.countByC_A_P_S(companyId, active, processId, status);
    }

    public WorkflowMetricsSLADefinition updateWorkflowMetricsSLADefinition(long workflowMetricsSLADefinitionId, String calendarKey, String description, long duration, String name, String[] pauseNodeKeys, String[] startNodeKeys, String[] stopNodeKeys, int status, ServiceContext serviceContext) throws PortalException {
        WorkflowMetricsSLADefinition workflowMetricsSLADefinition = this.workflowMetricsSLADefinitionPersistence.findByPrimaryKey(workflowMetricsSLADefinitionId);
        String latestProcessVersion = this._getLatestProcessVersion(workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId());
        this.validate(workflowMetricsSLADefinition.getWorkflowMetricsSLADefinitionId(), workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId(), latestProcessVersion, name, duration, pauseNodeKeys, startNodeKeys, stopNodeKeys);
        Date now = new Date();
        workflowMetricsSLADefinition.setModifiedDate(serviceContext.getModifiedDate(now));
        workflowMetricsSLADefinition.setCalendarKey(calendarKey);
        workflowMetricsSLADefinition.setDescription(description);
        workflowMetricsSLADefinition.setDuration(duration);
        workflowMetricsSLADefinition.setName(name);
        workflowMetricsSLADefinition.setPauseNodeKeys(StringUtil.merge((Object[])pauseNodeKeys));
        workflowMetricsSLADefinition.setProcessVersion(latestProcessVersion);
        workflowMetricsSLADefinition.setStartNodeKeys(StringUtil.merge((Object[])startNodeKeys));
        workflowMetricsSLADefinition.setStopNodeKeys(StringUtil.merge((Object[])stopNodeKeys));
        workflowMetricsSLADefinition.setVersion(this.getNextVersion(workflowMetricsSLADefinition.getVersion()));
        workflowMetricsSLADefinition.setStatus(status);
        User user = this.userLocalService.getUser(serviceContext.getGuestOrUserId());
        workflowMetricsSLADefinition.setStatusByUserId(user.getUserId());
        workflowMetricsSLADefinition.setStatusByUserName(user.getFullName());
        workflowMetricsSLADefinition.setStatusDate(serviceContext.getModifiedDate(now));
        workflowMetricsSLADefinition = (WorkflowMetricsSLADefinition)this.workflowMetricsSLADefinitionPersistence.update((BaseModel)workflowMetricsSLADefinition);
        this.addWorkflowMetricsSLADefinitionVersion(user, workflowMetricsSLADefinition);
        long companyId = workflowMetricsSLADefinition.getCompanyId();
        long processId = workflowMetricsSLADefinition.getProcessId();
        this._workflowMetricsPortalExecutor.execute(() -> this._slaProcessResultWorkflowMetricsIndexer.deleteDocuments(companyId, processId, workflowMetricsSLADefinitionId));
        this._workflowMetricsPortalExecutor.execute(() -> this._slaTaskResultWorkflowMetricsIndexer.deleteDocuments(companyId, processId, workflowMetricsSLADefinitionId));
        return workflowMetricsSLADefinition;
    }

    protected WorkflowMetricsSLADefinitionVersion addWorkflowMetricsSLADefinitionVersion(User user, WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {
        long workflowMetricsSLADefinitionVersionId = this.counterLocalService.increment();
        WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion = this.workflowMetricsSLADefinitionVersionPersistence.create(workflowMetricsSLADefinitionVersionId);
        workflowMetricsSLADefinitionVersion.setGroupId(workflowMetricsSLADefinition.getGroupId());
        workflowMetricsSLADefinitionVersion.setCompanyId(workflowMetricsSLADefinition.getCompanyId());
        workflowMetricsSLADefinitionVersion.setUserId(user.getUserId());
        workflowMetricsSLADefinitionVersion.setUserName(user.getFullName());
        Date now = new Date();
        workflowMetricsSLADefinitionVersion.setCreateDate(now);
        workflowMetricsSLADefinitionVersion.setModifiedDate(now);
        workflowMetricsSLADefinitionVersion.setActive(workflowMetricsSLADefinition.isActive());
        workflowMetricsSLADefinitionVersion.setCalendarKey(workflowMetricsSLADefinition.getCalendarKey());
        workflowMetricsSLADefinitionVersion.setDescription(workflowMetricsSLADefinition.getDescription());
        workflowMetricsSLADefinitionVersion.setDuration(workflowMetricsSLADefinition.getDuration());
        workflowMetricsSLADefinitionVersion.setName(workflowMetricsSLADefinition.getName());
        workflowMetricsSLADefinitionVersion.setPauseNodeKeys(workflowMetricsSLADefinition.getPauseNodeKeys());
        workflowMetricsSLADefinitionVersion.setProcessId(workflowMetricsSLADefinition.getProcessId());
        workflowMetricsSLADefinitionVersion.setProcessVersion(workflowMetricsSLADefinition.getProcessVersion());
        workflowMetricsSLADefinitionVersion.setStartNodeKeys(workflowMetricsSLADefinition.getStartNodeKeys());
        workflowMetricsSLADefinitionVersion.setStopNodeKeys(workflowMetricsSLADefinition.getStopNodeKeys());
        workflowMetricsSLADefinitionVersion.setVersion(workflowMetricsSLADefinition.getVersion());
        workflowMetricsSLADefinitionVersion.setWorkflowMetricsSLADefinitionId(workflowMetricsSLADefinition.getWorkflowMetricsSLADefinitionId());
        workflowMetricsSLADefinitionVersion.setStatus(workflowMetricsSLADefinition.getStatus());
        workflowMetricsSLADefinition.setStatusByUserId(user.getUserId());
        workflowMetricsSLADefinition.setStatusByUserName(user.getFullName());
        workflowMetricsSLADefinition.setStatusDate(now);
        return (WorkflowMetricsSLADefinitionVersion)this.workflowMetricsSLADefinitionVersionPersistence.update((BaseModel)workflowMetricsSLADefinitionVersion);
    }

    protected String getNextVersion(String version) {
        int[] versionParts = StringUtil.split((String)version, (String)".", (int)0);
        Object[] objectArray = new Object[3];
        versionParts[0] = versionParts[0] + 1;
        objectArray[0] = versionParts[0];
        objectArray[1] = ".";
        objectArray[2] = versionParts[1];
        return StringBundler.concat((Object[])objectArray);
    }

    protected void validate(long workflowMetricsSLADefinitionId, long companyId, long processId, String processVersion, String name, long duration, String[] pauseNodeKeys, String[] startNodeKeys, String[] stopNodeKeys) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new WorkflowMetricsSLADefinitionNameException();
        }
        if (duration <= 0L) {
            throw new WorkflowMetricsSLADefinitionDurationException();
        }
        List workflowMetricsSLADefinitions = this.workflowMetricsSLADefinitionPersistence.findByC_A_N_P(companyId, true, name, processId);
        if (ListUtil.isNotEmpty((List)workflowMetricsSLADefinitions) && (workflowMetricsSLADefinitionId == 0L || ListUtil.isNotEmpty((List)ListUtil.filter((List)workflowMetricsSLADefinitions, workflowMetricsSLADefinition -> {
            long filteredWorkflowMetricsSLADefinitionId = workflowMetricsSLADefinition.getWorkflowMetricsSLADefinitionId();
            return filteredWorkflowMetricsSLADefinitionId != workflowMetricsSLADefinitionId;
        })))) {
            throw new WorkflowMetricsSLADefinitionDuplicateNameException();
        }
        this.validateTimeframe(companyId, pauseNodeKeys, processId, processVersion, startNodeKeys, stopNodeKeys);
    }

    protected void validateTimeframe(long companyId, String[] pauseNodeKeys, long processId, String processVersion, String[] startNodeKeys, String[] stopNodeKeys) throws PortalException {
        long stopNodeIdsCount;
        long startNodeIdsCount;
        if (ArrayUtil.isEmpty((Object[])startNodeKeys)) {
            throw new WorkflowMetricsSLADefinitionStartNodeKeysException();
        }
        if (ArrayUtil.isEmpty((Object[])stopNodeKeys)) {
            throw new WorkflowMetricsSLADefinitionStopNodeKeysException();
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        Set<String> pauseNodeIds = this._getNodeIds(pauseNodeKeys);
        searchSearchRequest.addAggregation((Aggregation)this._createNodeIdAggregation("pause", pauseNodeIds));
        Set<String> startNodeIds = this._getNodeIds(startNodeKeys);
        searchSearchRequest.addAggregation((Aggregation)this._createNodeIdAggregation("start", startNodeIds));
        Set<String> stopNodeIds = this._getNodeIds(stopNodeKeys);
        searchSearchRequest.addAggregation((Aggregation)this._createNodeIdAggregation("stop", stopNodeIds));
        searchSearchRequest.setIndexNames(new String[]{this._nodeWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("processId", (Object)processId), this._queries.term("version", (Object)processVersion)}));
        SearchSearchResponse searchSearchResponse = this._searchRequestExecutor.executeSearchRequest(searchSearchRequest);
        Map aggregationResultsMap = searchSearchResponse.getAggregationResultsMap();
        ArrayList<String> fieldNames = new ArrayList<String>();
        long pauseNodeIdsCount = this._getNodeIdsCount((FilterAggregationResult)aggregationResultsMap.get("pause"));
        if (pauseNodeIdsCount != (long)pauseNodeIds.size()) {
            fieldNames.add("pauseNodeKeys");
        }
        if ((startNodeIdsCount = this._getNodeIdsCount((FilterAggregationResult)aggregationResultsMap.get("start"))) != (long)startNodeIds.size()) {
            fieldNames.add("startNodeKeys");
        }
        if ((stopNodeIdsCount = this._getNodeIdsCount((FilterAggregationResult)aggregationResultsMap.get("stop"))) != (long)stopNodeIds.size()) {
            fieldNames.add("stopNodeKeys");
        }
        if (!fieldNames.isEmpty()) {
            throw new WorkflowMetricsSLADefinitionTimeframeException(fieldNames);
        }
    }

    private FilterAggregation _createNodeIdAggregation(String aggregationName, Set<String> nodeIds) {
        TermsQuery termsQuery = this._queries.terms("nodeId");
        termsQuery.addValues(nodeIds.toArray());
        FilterAggregation filterAggregation = this._aggregations.filter(aggregationName, (Query)termsQuery);
        filterAggregation.addChildAggregation((Aggregation)this._aggregations.terms("nodeId", "nodeId"));
        return filterAggregation;
    }

    private String _getLatestProcessVersion(long companyId, long processId) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._processWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("processId", (Object)processId)});
        searchSearchRequest.setQuery((Query)booleanQuery);
        searchSearchRequest.setSelectedFieldNames(new String[]{"version"});
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).findFirst().map(document -> document.getString("version")).orElseGet(() -> "");
    }

    private Set<String> _getNodeIds(String[] nodeKeys) {
        if (nodeKeys == null) {
            return Collections.emptySet();
        }
        return Stream.of(nodeKeys).map(nodeKey -> StringUtil.split((String)nodeKey, (char)':')).map(nodeKeyParts -> nodeKeyParts[0]).collect(Collectors.toSet());
    }

    private long _getNodeIdsCount(FilterAggregationResult filterAggregationResult) {
        TermsAggregationResult termsAggregationResult = (TermsAggregationResult)filterAggregationResult.getChildAggregationResult("nodeId");
        Collection buckets = termsAggregationResult.getBuckets();
        return buckets.size();
    }
}

