/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.transformer;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.aggregation.Aggregation;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.Bucket;
import com.liferay.portal.search.aggregation.bucket.TermsAggregation;
import com.liferay.portal.search.aggregation.bucket.TermsAggregationResult;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregation;
import com.liferay.portal.search.aggregation.metrics.TopHitsAggregationResult;
import com.liferay.portal.search.engine.adapter.search.SearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowMetricsSLADefinitionTransformer.class})
public class WorkflowMetricsSLADefinitionTransformer {
    @Reference
    private Aggregations _aggregations;
    @Reference(target="(workflow.metrics.index.entity.name=node)")
    private WorkflowMetricsIndexNameBuilder _nodeWorkflowMetricsIndexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestExecutor _searchRequestExecutor;
    @Reference
    private WorkflowMetricsSLADefinitionLocalService _workflowMetricsSLADefinitionLocalService;

    public void transform(long companyId, String latestProcessVersion, long processId) throws PortalException {
        List workflowMetricsSLADefinitions = this._workflowMetricsSLADefinitionLocalService.getWorkflowMetricsSLADefinitions(companyId, true, processId, latestProcessVersion, 0);
        for (WorkflowMetricsSLADefinition workflowMetricsSLADefinition : workflowMetricsSLADefinitions) {
            this._transform(latestProcessVersion, workflowMetricsSLADefinition);
        }
    }

    protected String getNodeId(String processVersion, TermsAggregationResult versionTermsAggregationResult) {
        Bucket processVersionBucket = versionTermsAggregationResult.getBucket(processVersion);
        TopHitsAggregationResult topHitsAggregationResult = (TopHitsAggregationResult)processVersionBucket.getChildAggregationResult("topHits");
        return Stream.of(topHitsAggregationResult.getSearchHits()).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getSourcesMap).findFirst().map(sourceMap -> MapUtil.getString((Map)sourceMap, (String)"nodeId")).orElseGet(() -> "");
    }

    private BooleanQuery _createNodeBooleanQuery(String currentProcessVersion, String latestProcessVersion, WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        TermsQuery termsQuery = this._queries.terms("version");
        termsQuery.addValues(new Object[]{currentProcessVersion, latestProcessVersion});
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("companyId", (Object)workflowMetricsSLADefinition.getCompanyId()), this._queries.term("processId", (Object)workflowMetricsSLADefinition.getProcessId()), termsQuery});
    }

    private Map<String, String> _getNodeIdMap(String currentProcessVersion, String latestProcessVersion, WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        TermsAggregation nameTermsAggregation = this._aggregations.terms("name", "name");
        nameTermsAggregation.setSize(Integer.valueOf(10000));
        TermsAggregation versionTermsAggregation = this._aggregations.terms("version", "version");
        TopHitsAggregation topHitsAggregation = this._aggregations.topHits("topHits");
        topHitsAggregation.setSize(Integer.valueOf(2));
        versionTermsAggregation.addChildAggregation((Aggregation)topHitsAggregation);
        versionTermsAggregation.setSize(Integer.valueOf(10000));
        nameTermsAggregation.addChildAggregation((Aggregation)versionTermsAggregation);
        searchSearchRequest.addAggregation((Aggregation)nameTermsAggregation);
        searchSearchRequest.setIndexNames(new String[]{this._nodeWorkflowMetricsIndexNameBuilder.getIndexName(workflowMetricsSLADefinition.getCompanyId())});
        searchSearchRequest.setQuery((Query)this._createNodeBooleanQuery(currentProcessVersion, latestProcessVersion, workflowMetricsSLADefinition));
        searchSearchRequest.setSize(Integer.valueOf(0));
        SearchSearchResponse searchSearchResponse = this._searchRequestExecutor.executeSearchRequest(searchSearchRequest);
        Map aggregationResultsMap = searchSearchResponse.getAggregationResultsMap();
        TermsAggregationResult nameTermsAggregationResult = (TermsAggregationResult)aggregationResultsMap.get("name");
        return Stream.of(nameTermsAggregationResult.getBuckets()).flatMap(Collection::parallelStream).map(bucket -> (TermsAggregationResult)bucket.getChildAggregationResult("version")).filter(versionTermsAggregationResult -> {
            Collection versionBuckets = versionTermsAggregationResult.getBuckets();
            return versionBuckets.size() == 2;
        }).collect(Collectors.toMap(versionTermsAggregationResult -> this.getNodeId(currentProcessVersion, (TermsAggregationResult)versionTermsAggregationResult), versionTermsAggregationResult -> this.getNodeId(latestProcessVersion, (TermsAggregationResult)versionTermsAggregationResult)));
    }

    private void _transform(String latestProcessVersion, final WorkflowMetricsSLADefinition workflowMetricsSLADefinition) throws PortalException {
        Map<String, String> nodeIdMap = this._getNodeIdMap(workflowMetricsSLADefinition.getProcessVersion(), latestProcessVersion, workflowMetricsSLADefinition);
        String[] pauseNodeKeys = this._transformNodeKeys(nodeIdMap, StringUtil.split((String)workflowMetricsSLADefinition.getPauseNodeKeys()));
        Object[] startNodeKeys = this._transformNodeKeys(nodeIdMap, StringUtil.split((String)workflowMetricsSLADefinition.getStartNodeKeys()));
        Object[] stopNodeKeys = this._transformNodeKeys(nodeIdMap, StringUtil.split((String)workflowMetricsSLADefinition.getStopNodeKeys()));
        int status = 0;
        if (ArrayUtil.isEmpty((Object[])startNodeKeys) || ArrayUtil.isEmpty((Object[])stopNodeKeys)) {
            status = 2;
        }
        this._workflowMetricsSLADefinitionLocalService.updateWorkflowMetricsSLADefinition(workflowMetricsSLADefinition.getWorkflowMetricsSLADefinitionId(), workflowMetricsSLADefinition.getCalendarKey(), workflowMetricsSLADefinition.getDescription(), workflowMetricsSLADefinition.getDuration(), workflowMetricsSLADefinition.getName(), pauseNodeKeys, (String[])startNodeKeys, (String[])stopNodeKeys, status, new ServiceContext(){
            {
                this.setCompanyId(workflowMetricsSLADefinition.getCompanyId());
                this.setScopeGroupId(workflowMetricsSLADefinition.getGroupId());
                this.setUserId(workflowMetricsSLADefinition.getUserId());
            }
        });
    }

    private String[] _transformNodeKeys(Map<String, String> nodeIdMap, List<String> oldNodeKeys) {
        ArrayList<String> newNodeKeys = new ArrayList<String>();
        for (String oldNodeKey : oldNodeKeys) {
            List parts = StringUtil.split((String)oldNodeKey, (char)':');
            String oldNodeId = (String)parts.get(0);
            if (!nodeIdMap.containsKey(oldNodeId)) continue;
            if (parts.size() == 1) {
                newNodeKeys.add(nodeIdMap.get(oldNodeId));
                continue;
            }
            newNodeKeys.add(StringBundler.concat((Object[])new Object[]{nodeIdMap.get(oldNodeId), Character.valueOf(':'), parts.get(1)}));
        }
        return newNodeKeys.toArray(new String[0]);
    }
}

