/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.processor;

import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessor;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Stack;

public class WorkflowMetricsSLAStopwatch {
    private final Stack<WorkflowMetricsSLAProcessor.TaskInterval> _taskIntervals = new Stack();
    private WorkfowMetricsSLAStatus _workfowMetricsSLAStatus;

    public WorkflowMetricsSLAStopwatch(WorkfowMetricsSLAStatus workfowMetricsSLAStatus) {
        this._workfowMetricsSLAStatus = workfowMetricsSLAStatus;
    }

    public List<WorkflowMetricsSLAProcessor.TaskInterval> getTaskIntervals() {
        return this._taskIntervals;
    }

    public WorkfowMetricsSLAStatus getWorkfowMetricsSLAStatus() {
        return this._workfowMetricsSLAStatus;
    }

    public boolean isEmpty() {
        return this._taskIntervals.isEmpty();
    }

    public boolean isRunning() {
        return this._workfowMetricsSLAStatus == WorkfowMetricsSLAStatus.RUNNING;
    }

    public boolean isStopped() {
        return this._workfowMetricsSLAStatus == WorkfowMetricsSLAStatus.STOPPED;
    }

    public void pause(LocalDateTime endLocalDateTime) {
        if (this.isStopped()) {
            throw new IllegalStateException("Stopwatch is stopped");
        }
        if (!this.isEmpty()) {
            WorkflowMetricsSLAProcessor.TaskInterval taskInterval = this._taskIntervals.peek();
            taskInterval.setEndLocalDateTime(endLocalDateTime);
        }
        this._workfowMetricsSLAStatus = WorkfowMetricsSLAStatus.PAUSED;
    }

    public void run(LocalDateTime startLocalDateTime) {
        if (this.isStopped()) {
            throw new IllegalStateException("Stopwatch is stopped");
        }
        if (this.isRunning() && !this.isEmpty()) {
            return;
        }
        WorkflowMetricsSLAProcessor.TaskInterval taskInterval = new WorkflowMetricsSLAProcessor.TaskInterval();
        taskInterval.setEndLocalDateTime(LocalDateTime.MAX);
        taskInterval.setStartLocalDateTime(startLocalDateTime);
        this._taskIntervals.push(taskInterval);
        this._workfowMetricsSLAStatus = WorkfowMetricsSLAStatus.RUNNING;
    }

    public void stop(LocalDateTime endLocalDateTime) {
        if (this.isStopped()) {
            throw new IllegalStateException("Stopwatch is already stopped");
        }
        if (!this.isEmpty()) {
            WorkflowMetricsSLAProcessor.TaskInterval taskInterval = this._taskIntervals.peek();
            taskInterval.setEndLocalDateTime(endLocalDateTime);
        }
        this._workfowMetricsSLAStatus = WorkfowMetricsSLAStatus.STOPPED;
    }
}

