/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.processor;

import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.ExistsFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.search.SearchRequestExecutor;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.filter.DateRangeFilter;
import com.liferay.portal.search.filter.DateRangeFilterBuilder;
import com.liferay.portal.search.filter.FilterBuilders;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessResult;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAStopwatch;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLATaskResult;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.search.index.name.WorkflowMetricsIndexNameBuilder;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendar;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendarTracker;
import com.liferay.portal.workflow.metrics.sla.processor.WorkfowMetricsSLAStatus;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowMetricsSLAProcessor.class})
public class WorkflowMetricsSLAProcessor {
    private final DateTimeFormatter _dateTimeFormatter = DateTimeFormatter.ofPattern(PropsUtil.get((String)"index.date.format.pattern"));
    @Reference
    private FilterBuilders _filterBuilders;
    @Reference
    private SearchRequestExecutor _searchRequestExecutor;
    @Reference(target="(workflow.metrics.index.entity.name=sla-process-result)")
    private WorkflowMetricsIndexNameBuilder _slaProcessResultWorkflowMetricsIndexNameBuilder;
    @Reference
    private Sorts _sorts;
    @Reference(target="(workflow.metrics.index.entity.name=token)")
    private WorkflowMetricsIndexNameBuilder _tokenWorkflowMetricsIndexNameBuilder;
    @Reference
    private WorkflowMetricsSLACalendarTracker _workflowMetricsSLACalendarTracker;

    public Optional<WorkflowMetricsSLAProcessResult> process(long companyId, LocalDateTime createLocalDateTime, long instanceId, LocalDateTime nowLocalDateTime, long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion) {
        WorkflowMetricsSLAProcessResult lastWorkflowMetricsSLAProcessResult = this.fetchLastWorkflowMetricsSLAProcessResult(workflowMetricsSLADefinitionVersion, instanceId);
        long elapsedTime = 0L;
        LocalDateTime lastCheckLocalDateTime = null;
        WorkfowMetricsSLAStatus workfowMetricsSLAStatus = WorkfowMetricsSLAStatus.NEW;
        if (lastWorkflowMetricsSLAProcessResult != null) {
            elapsedTime = lastWorkflowMetricsSLAProcessResult.getElapsedTime();
            lastCheckLocalDateTime = lastWorkflowMetricsSLAProcessResult.getLastCheckLocalDateTime();
            workfowMetricsSLAStatus = lastWorkflowMetricsSLAProcessResult.getWorkfowMetricsSLAStatus();
            if (lastCheckLocalDateTime.isAfter(nowLocalDateTime) || Objects.equals(workfowMetricsSLAStatus, WorkfowMetricsSLAStatus.COMPLETED)) {
                return Optional.empty();
            }
        }
        List<Document> documents = this.getDocuments(companyId, instanceId, lastCheckLocalDateTime);
        WorkflowMetricsSLACalendar workflowMetricsSLACalendar = this._workflowMetricsSLACalendarTracker.getWorkflowMetricsSLACalendar(workflowMetricsSLADefinitionVersion.getCalendarKey());
        WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch = this._createWorkflowMetricsSLAStopwatch(documents, createLocalDateTime, lastCheckLocalDateTime, startNodeId, workflowMetricsSLADefinitionVersion, workfowMetricsSLAStatus);
        if (!workflowMetricsSLAStopwatch.isEmpty()) {
            List<TaskInterval> taskIntervals = this._toTaskIntervals(documents, lastCheckLocalDateTime, nowLocalDateTime);
            for (TaskInterval taskInterval : taskIntervals) {
                elapsedTime += this._computeElapsedTime(taskInterval.getEndLocalDateTime(), taskInterval.getStartLocalDateTime(), workflowMetricsSLACalendar, workflowMetricsSLAStopwatch);
            }
            workfowMetricsSLAStatus = workflowMetricsSLAStopwatch.getWorkfowMetricsSLAStatus();
        }
        return Optional.of(this._createWorkflowMetricsSLAProcessResult(companyId, documents, elapsedTime, instanceId, nowLocalDateTime, workflowMetricsSLACalendar, workflowMetricsSLADefinitionVersion, workfowMetricsSLAStatus));
    }

    protected WorkflowMetricsSLAProcessResult fetchLastWorkflowMetricsSLAProcessResult(final WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, final long instanceId) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._slaProcessResultWorkflowMetricsIndexNameBuilder.getIndexName(workflowMetricsSLADefinitionVersion.getCompanyId())});
        searchSearchRequest.setQuery((Query)new BooleanQueryImpl(){
            {
                this.setPreBooleanFilter(new BooleanFilter(){
                    {
                        this.addRequiredTerm("companyId", workflowMetricsSLADefinitionVersion.getCompanyId());
                        this.addRequiredTerm("deleted", false);
                        this.addRequiredTerm("instanceId", instanceId);
                        this.addRequiredTerm("slaDefinitionId", workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId());
                    }
                });
            }
        });
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).findFirst().map(document -> new WorkflowMetricsSLAProcessResult((Document)document, instanceId){
            final /* synthetic */ Document val$document;
            final /* synthetic */ long val$instanceId;
            {
                this.val$document = document;
                this.val$instanceId = l;
                this.setCompanyId(workflowMetricsSLADefinitionVersion.getCompanyId());
                this.setElapsedTime(this.val$document.getLong("elapsedTime"));
                this.setInstanceId(this.val$instanceId);
                this.setLastCheckLocalDateTime(LocalDateTime.parse(this.val$document.getString("lastCheckDate"), WorkflowMetricsSLAProcessor.this._dateTimeFormatter));
                this.setOnTime(GetterUtil.getBoolean((Object)this.val$document.getValue("onTime")));
                this.setOverdueLocalDateTime(LocalDateTime.parse(this.val$document.getString("overdueDate"), WorkflowMetricsSLAProcessor.this._dateTimeFormatter));
                this.setProcessId(workflowMetricsSLADefinitionVersion.getProcessId());
                this.setRemainingTime(this.val$document.getLong("remainingTime"));
                this.setSLADefinitionId(workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId());
                this.setWorkfowMetricsSLAStatus(WorkfowMetricsSLAStatus.valueOf((String)this.val$document.getString("status")));
            }
        }).orElseGet(() -> null);
    }

    protected List<Document> getDocuments(final long companyId, final long instanceId, final LocalDateTime lastCheckLocalDateTime) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.addSorts(new Sort[]{this._sorts.field(Field.getSortableFieldName((String)"createDate_Number"), SortOrder.ASC)});
        searchSearchRequest.setIndexNames(new String[]{this._tokenWorkflowMetricsIndexNameBuilder.getIndexName(companyId)});
        searchSearchRequest.setQuery((Query)new BooleanQueryImpl(){
            {
                this.setPreBooleanFilter(new BooleanFilter(){
                    {
                        this.addRequiredTerm("companyId", companyId);
                        this.addRequiredTerm("deleted", false);
                        this.addRequiredTerm("instanceId", instanceId);
                        if (lastCheckLocalDateTime != null) {
                            this.add((Filter)WorkflowMetricsSLAProcessor.this._createCompletionDateRangeFilter(lastCheckLocalDateTime), BooleanClauseOccur.SHOULD);
                            this.add((Filter)new BooleanFilter(){
                                {
                                    this.add((Filter)new ExistsFilter("completionDate"), BooleanClauseOccur.MUST_NOT);
                                }
                            }, BooleanClauseOccur.SHOULD);
                        }
                    }
                });
            }
        });
        searchSearchRequest.setSize(Integer.valueOf(10000));
        return Stream.of(this._searchRequestExecutor.executeSearchRequest(searchSearchRequest)).map(SearchSearchResponse::getSearchHits).map(SearchHits::getSearchHits).flatMap(Collection::parallelStream).map(SearchHit::getDocument).collect(Collectors.toList());
    }

    protected boolean isBreached(Document document, LocalDateTime nowLocalDateTime, LocalDateTime overdueLocalDateTime) {
        if (nowLocalDateTime.isBefore(overdueLocalDateTime)) {
            return false;
        }
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getString("createDate"), this._dateTimeFormatter);
        if (createDateLocalDateTime.isAfter(overdueLocalDateTime)) {
            return false;
        }
        if (Validator.isNull((Object)document.getValue("completionDate"))) {
            return true;
        }
        LocalDateTime completionDateLocalDateTime = LocalDateTime.parse(document.getString("completionDate"), this._dateTimeFormatter);
        return completionDateLocalDateTime.isAfter(overdueLocalDateTime);
    }

    protected boolean isOnTime(Document document, LocalDateTime nowLocalDateTime, LocalDateTime overdueLocalDateTime) {
        if (nowLocalDateTime.isBefore(overdueLocalDateTime)) {
            return true;
        }
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getString("createDate"), this._dateTimeFormatter);
        if (createDateLocalDateTime.isAfter(overdueLocalDateTime)) {
            return false;
        }
        if (Validator.isNull((Object)document.getValue("completionDate"))) {
            return false;
        }
        LocalDateTime completionDateLocalDateTime = LocalDateTime.parse(document.getString("completionDate"), this._dateTimeFormatter);
        return completionDateLocalDateTime.isBefore(overdueLocalDateTime) || Objects.equals(completionDateLocalDateTime, overdueLocalDateTime);
    }

    private long _computeElapsedTime(LocalDateTime endLocalDateTime, LocalDateTime starLocalDateTime, WorkflowMetricsSLACalendar workflowMetricsSLACalendar, WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch) {
        long elapsedTime = 0L;
        for (TaskInterval taskInterval : workflowMetricsSLAStopwatch.getTaskIntervals()) {
            if (endLocalDateTime.isBefore(taskInterval._startLocalDateTime) || starLocalDateTime.isAfter(taskInterval._endLocalDateTime)) continue;
            Duration duration = workflowMetricsSLACalendar.getDuration(this._getMaxLocalDateTime(starLocalDateTime, taskInterval._startLocalDateTime), this._getMinLocalDateTime(endLocalDateTime, taskInterval._endLocalDateTime));
            elapsedTime += duration.toMillis();
        }
        return elapsedTime;
    }

    private DateRangeFilter _createCompletionDateRangeFilter(LocalDateTime lastCheckLocalDateTime) {
        DateRangeFilterBuilder completionDateRangeFilterBuilder = this._filterBuilders.dateRangeFilterBuilder();
        completionDateRangeFilterBuilder.setFieldName("completionDate");
        completionDateRangeFilterBuilder.setFrom(this._dateTimeFormatter.format(lastCheckLocalDateTime));
        return completionDateRangeFilterBuilder.build();
    }

    private WorkflowMetricsSLAProcessResult _createWorkflowMetricsSLAProcessResult(final long companyId, List<Document> documents, final long elapsedTime, final long instanceId, final LocalDateTime nowLocalDateTime, final WorkflowMetricsSLACalendar workflowMetricsSLACalendar, final WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, final WorkfowMetricsSLAStatus workfowMetricsSLAStatus) {
        WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult = new WorkflowMetricsSLAProcessResult(){
            {
                this.setCompanyId(companyId);
                this.setElapsedTime(elapsedTime);
                this.setInstanceId(instanceId);
                this.setLastCheckLocalDateTime(nowLocalDateTime);
                this.setOnTime(elapsedTime <= workflowMetricsSLADefinitionVersion.getDuration());
                long remainingTime = WorkflowMetricsSLAProcessor.this._getRemainingTime(elapsedTime, workflowMetricsSLADefinitionVersion);
                this.setOverdueLocalDateTime(workflowMetricsSLACalendar.getOverdueLocalDateTime(nowLocalDateTime, Duration.ofMillis(remainingTime)));
                this.setProcessId(workflowMetricsSLADefinitionVersion.getProcessId());
                this.setRemainingTime(remainingTime);
                this.setSLADefinitionId(workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId());
                this.setWorkfowMetricsSLAStatus(workfowMetricsSLAStatus);
            }
        };
        workflowMetricsSLAProcessResult.setWorkflowMetricsSLATaskResults(this._createWorkflowMetricsSLATaskResults(documents, nowLocalDateTime, workflowMetricsSLAProcessResult));
        return workflowMetricsSLAProcessResult;
    }

    private WorkflowMetricsSLAStopwatch _createWorkflowMetricsSLAStopwatch(List<Document> documents, LocalDateTime createDateLocalDateTime, LocalDateTime lastCheckLocalDateTime, long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, WorkfowMetricsSLAStatus workfowMetricsSLAStatus) {
        WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch = new WorkflowMetricsSLAStopwatch(workfowMetricsSLAStatus);
        Map<Long, String> startTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getStartNodeKeys()));
        if (Objects.equals(workfowMetricsSLAStatus, WorkfowMetricsSLAStatus.NEW) && startTimeMarkers.containsKey(startNodeId)) {
            workflowMetricsSLAStopwatch.run(createDateLocalDateTime);
        } else if (Objects.equals(workfowMetricsSLAStatus, WorkfowMetricsSLAStatus.RUNNING)) {
            workflowMetricsSLAStopwatch.run(lastCheckLocalDateTime);
        }
        Map<Long, String> pauseTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getPauseNodeKeys()));
        Map<Long, String> stopTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getStopNodeKeys()));
        Iterator<Document> iterator = documents.iterator();
        while (iterator.hasNext() && !workflowMetricsSLAStopwatch.isStopped()) {
            Document document = iterator.next();
            long taskId = document.getLong("taskId");
            TaskInterval taskInterval = this._toTaskInterval(document, lastCheckLocalDateTime, null);
            if (pauseTimeMarkers.containsKey(taskId) && !stopTimeMarkers.containsKey(taskId)) {
                workflowMetricsSLAStopwatch.pause(taskInterval._startLocalDateTime);
                if (taskInterval._endLocalDateTime != null) {
                    workflowMetricsSLAStopwatch.run(taskInterval._endLocalDateTime);
                }
            }
            if (startTimeMarkers.containsKey(taskId)) {
                if (Objects.equals(startTimeMarkers.get(taskId), "enter")) {
                    workflowMetricsSLAStopwatch.run(taskInterval._startLocalDateTime);
                } else if (Objects.equals(startTimeMarkers.get(taskId), "leave") && taskInterval._endLocalDateTime != null) {
                    workflowMetricsSLAStopwatch.run(taskInterval._endLocalDateTime);
                }
            }
            if (!stopTimeMarkers.containsKey(taskId)) continue;
            if (Objects.equals(stopTimeMarkers.get(taskId), "enter")) {
                workflowMetricsSLAStopwatch.stop(taskInterval._startLocalDateTime);
                continue;
            }
            if (!Objects.equals(stopTimeMarkers.get(taskId), "leave") || taskInterval._endLocalDateTime == null) continue;
            workflowMetricsSLAStopwatch.stop(taskInterval._endLocalDateTime);
        }
        return workflowMetricsSLAStopwatch;
    }

    private WorkflowMetricsSLATaskResult _createWorkflowMetricsSLATaskResult(final Document document, final LocalDateTime nowLocalDateTime, final WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult) {
        return new WorkflowMetricsSLATaskResult(){
            {
                this.setBreached(WorkflowMetricsSLAProcessor.this.isBreached(document, nowLocalDateTime, workflowMetricsSLAProcessResult.getOverdueLocalDateTime()));
                this.setCompanyId(workflowMetricsSLAProcessResult.getCompanyId());
                this.setInstanceId(workflowMetricsSLAProcessResult.getInstanceId());
                this.setLastCheckLocalDateTime(workflowMetricsSLAProcessResult.getLastCheckLocalDateTime());
                this.setOnTime(WorkflowMetricsSLAProcessor.this.isOnTime(document, nowLocalDateTime, workflowMetricsSLAProcessResult.getOverdueLocalDateTime()));
                this.setProcessId(workflowMetricsSLAProcessResult.getProcessId());
                this.setSLADefinitionId(workflowMetricsSLAProcessResult.getSLADefinitionId());
                this.setTaskId(document.getLong("taskId"));
                this.setTaskName(document.getString("taskName"));
                this.setTokenId(document.getLong("tokenId"));
                this.setWorkfowMetricsSLAStatus(WorkflowMetricsSLAProcessor.this._getWorkfowMetricsSLAStatus(document, workflowMetricsSLAProcessResult));
            }
        };
    }

    private List<WorkflowMetricsSLATaskResult> _createWorkflowMetricsSLATaskResults(List<Document> documents, LocalDateTime nowLocalDateTime, WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult) {
        Stream stream = documents.stream();
        return stream.map(document -> this._createWorkflowMetricsSLATaskResult((Document)document, nowLocalDateTime, workflowMetricsSLAProcessResult)).collect(Collectors.toList());
    }

    private LocalDateTime _getMaxLocalDateTime(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        if (localDateTime1.isAfter(localDateTime2)) {
            return localDateTime1;
        }
        return localDateTime2;
    }

    private LocalDateTime _getMinLocalDateTime(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        if (localDateTime1.isBefore(localDateTime2)) {
            return localDateTime1;
        }
        return localDateTime2;
    }

    private long _getRemainingTime(long elapsedTime, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion) {
        return Math.min(863913600000L, workflowMetricsSLADefinitionVersion.getDuration() - elapsedTime);
    }

    private Map<Long, String> _getTimeMarkers(List<String> nodeKeys) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (String nodeKey : nodeKeys) {
            List parts = StringUtil.split((String)nodeKey, (char)':');
            long nodeId = GetterUtil.getLong((String)((String)parts.get(0)));
            if (parts.size() == 1) {
                map.put(nodeId, "");
                continue;
            }
            map.put(nodeId, (String)parts.get(1));
        }
        return map;
    }

    private WorkfowMetricsSLAStatus _getWorkfowMetricsSLAStatus(Document document, WorkflowMetricsSLAProcessResult workflowMetricsSLAProcessResult) {
        if (Objects.equals(workflowMetricsSLAProcessResult.getWorkfowMetricsSLAStatus(), WorkfowMetricsSLAStatus.NEW)) {
            return WorkfowMetricsSLAStatus.NEW;
        }
        if (GetterUtil.getBoolean((Object)document.getBoolean("completed"))) {
            return WorkfowMetricsSLAStatus.COMPLETED;
        }
        return WorkfowMetricsSLAStatus.RUNNING;
    }

    private TaskInterval _toTaskInterval(Document document, LocalDateTime lastCheckLocalDateTime, LocalDateTime nowLocalDateTime) {
        TaskInterval taskInterval = new TaskInterval();
        if (Validator.isNull((Object)document.getValue("completionDate"))) {
            taskInterval._endLocalDateTime = nowLocalDateTime;
        } else {
            taskInterval._endLocalDateTime = LocalDateTime.parse(document.getString("completionDate"), this._dateTimeFormatter);
        }
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getString("createDate"), this._dateTimeFormatter);
        if (lastCheckLocalDateTime != null && lastCheckLocalDateTime.isAfter(createDateLocalDateTime)) {
            taskInterval._startLocalDateTime = lastCheckLocalDateTime;
        } else {
            taskInterval._startLocalDateTime = createDateLocalDateTime;
        }
        return taskInterval;
    }

    private List<TaskInterval> _toTaskIntervals(List<Document> documents, LocalDateTime lastCheckLocalDateTime, LocalDateTime nowLocalDateTime) {
        if (ListUtil.isEmpty(documents)) {
            return Collections.emptyList();
        }
        Stack<TaskInterval> taskIntervals = new Stack<TaskInterval>();
        taskIntervals.push(this._toTaskInterval(documents.get(0), lastCheckLocalDateTime, nowLocalDateTime));
        for (Document document : documents) {
            TaskInterval topTaskInterval = taskIntervals.peek();
            TaskInterval taskInterval = this._toTaskInterval(document, lastCheckLocalDateTime, nowLocalDateTime);
            LocalDateTime topEndLocalDateTime = topTaskInterval.getEndLocalDateTime();
            if (topEndLocalDateTime.isBefore(taskInterval.getStartLocalDateTime())) {
                taskIntervals.push(taskInterval);
                continue;
            }
            if (!topEndLocalDateTime.isBefore(taskInterval.getEndLocalDateTime())) continue;
            topTaskInterval._endLocalDateTime = taskInterval.getEndLocalDateTime();
        }
        return taskIntervals;
    }

    protected static class TaskInterval {
        private LocalDateTime _endLocalDateTime;
        private LocalDateTime _startLocalDateTime;

        protected TaskInterval() {
        }

        public LocalDateTime getEndLocalDateTime() {
            return this._endLocalDateTime;
        }

        public LocalDateTime getStartLocalDateTime() {
            return this._startLocalDateTime;
        }

        public void setEndLocalDateTime(LocalDateTime endLocalDateTime) {
            this._endLocalDateTime = endLocalDateTime;
        }

        public void setStartLocalDateTime(LocalDateTime startLocalDateTime) {
            this._startLocalDateTime = startLocalDateTime;
        }
    }
}

