/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.calendar;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendar;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendarTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=false, service={WorkflowMetricsSLACalendarTracker.class})
public class WorkflowMetricsSLACalendarTrackerImpl
implements WorkflowMetricsSLACalendarTracker {
    @Reference(target="(sla.calendar.key=default)")
    private WorkflowMetricsSLACalendar _defaultWorkflowMetricsSLACalendar;
    private final Map<String, WorkflowMetricsSLACalendar> _workflowMetricsSLACalendars = new HashMap<String, WorkflowMetricsSLACalendar>();

    public WorkflowMetricsSLACalendar getWorkflowMetricsSLACalendar(String key) {
        return this._workflowMetricsSLACalendars.getOrDefault(key, this._defaultWorkflowMetricsSLACalendar);
    }

    public Map<String, String> getWorkflowMetricsSLACalendarTitles(Locale locale) {
        return Stream.of(this._workflowMetricsSLACalendars.entrySet()).flatMap(Collection::stream).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            WorkflowMetricsSLACalendar workflowMetricsSLACalendar = (WorkflowMetricsSLACalendar)entry.getValue();
            return workflowMetricsSLACalendar.getTitle(locale);
        }));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addWorkflowMetricsSLACalendar(WorkflowMetricsSLACalendar workflowMetricsSLACalendar, Map<String, Object> properties) {
        String key = MapUtil.getString(properties, (String)"sla.calendar.key");
        this._workflowMetricsSLACalendars.put(key, workflowMetricsSLACalendar);
    }

    @Deactivate
    protected void deactivate() {
        this._workflowMetricsSLACalendars.clear();
    }

    protected void removeWorkflowMetricsSLACalendar(WorkflowMetricsSLACalendar workflowMetricsSLACalendar, Map<String, Object> properties) {
        String key = MapUtil.getString(properties, (String)"sla.calendar.key");
        this._workflowMetricsSLACalendars.remove(key);
    }
}

