/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.calendar;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendar;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=false, property={"sla.calendar.key=default"}, service={WorkflowMetricsSLACalendar.class})
public class DefaultWorkflowMetricsSLACalendar
implements WorkflowMetricsSLACalendar {
    @Reference
    private Language _language;

    public Duration getDuration(LocalDateTime startLocalDateTime, LocalDateTime endLocalDateTime) {
        return Duration.between(startLocalDateTime, endLocalDateTime);
    }

    public LocalDateTime getOverdueLocalDateTime(LocalDateTime nowLocalDateTime, Duration remainingDuration) {
        return nowLocalDateTime.plus(remainingDuration.toMillis(), ChronoUnit.MILLIS);
    }

    public String getTitle(Locale locale) {
        return this._language.get(ResourceBundleUtil.getBundle((Locale)locale, DefaultWorkflowMetricsSLACalendar.class), "default-calendar-title");
    }
}

