/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index.creation.instance.lifecycle;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.workflow.metrics.internal.search.index.InstanceWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.NodeWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.ProcessWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAProcessResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.TokenWorkflowMetricsIndexer;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class WorkflowMetricsPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private InstanceWorkflowMetricsIndexer _instanceWorkflowMetricsIndexer;
    @Reference
    private NodeWorkflowMetricsIndexer _nodeWorkflowMetricsIndexer;
    @Reference
    private ProcessWorkflowMetricsIndexer _processWorkflowMetricsIndexer;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(search.engine.impl=Elasticsearch)")
    private volatile SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private SLAProcessResultWorkflowMetricsIndexer _slaProcessResultWorkflowMetricsIndexer;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @Reference
    private TokenWorkflowMetricsIndexer _tokenWorkflowMetricsIndexer;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (Objects.isNull(this._searchEngineAdapter)) {
            return;
        }
        this._instanceWorkflowMetricsIndexer.createIndex(company.getCompanyId());
        this._nodeWorkflowMetricsIndexer.createIndex(company.getCompanyId());
        this._processWorkflowMetricsIndexer.createIndex(company.getCompanyId());
        this._slaProcessResultWorkflowMetricsIndexer.createIndex(company.getCompanyId());
        this._slaTaskResultWorkflowMetricsIndexer.createIndex(company.getCompanyId());
        this._tokenWorkflowMetricsIndexer.createIndex(company.getCompanyId());
    }

    public void portalInstanceUnregistered(Company company) throws Exception {
        if (Objects.isNull(this._searchEngineAdapter)) {
            return;
        }
        this._instanceWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
        this._nodeWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
        this._processWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
        this._slaProcessResultWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
        this._slaTaskResultWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
        this._tokenWorkflowMetricsIndexer.removeIndex(company.getCompanyId());
    }
}

